/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.resource;

import br.com.elotech.portaltransparencia.protocportal.dto.EstatisticaDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.SerieItemDTO;
import br.com.elotech.portaltransparencia.protocportal.resource.params.EstatisticaParams;
import br.com.elotech.portaltransparencia.protocportal.service.EstatisticaService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/estatisticas"})
public class EstatisticaResource {
    private final EstatisticaService service;

    public EstatisticaResource(EstatisticaService service) {
        this.service = service;
    }

    @GetMapping
    public ResponseEntity<List<EstatisticaDTO>> findEstatisticas(EstatisticaParams params) {
        return ResponseEntity.ok((Object)this.service.findEstatisticas(params));
    }

    @GetMapping(value={"/media"})
    public ResponseEntity<BigDecimal> getMediaRespostas(EstatisticaParams params) {
        return ResponseEntity.ok((Object)this.service.getMediaResposta(params));
    }

    @GetMapping(value={"/processos-por-genero"})
    public ResponseEntity<List<SerieItemDTO>> findProcessosPorGenero(EstatisticaParams params) {
        return ResponseEntity.ok((Object)this.service.findProcessosPorGenero(params));
    }

    @GetMapping(value={"/processos-por-idade"})
    public ResponseEntity<List<SerieItemDTO>> findProcessosPorIdade(EstatisticaParams params) {
        return ResponseEntity.ok((Object)this.service.findProcessosPorIdade(params));
    }

    @GetMapping(value={"/processos-por-escolaridade"})
    public ResponseEntity<List<SerieItemDTO>> findProcessosPorEscolaridade(EstatisticaParams params) {
        return ResponseEntity.ok((Object)this.service.findProcessosPorEscolaridade(params));
    }
}

