/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Funcao {
    ABERTO("C", "Aberto", "Abrir"),
    ENCAMINHADO("E", "Encaminhado", "Encaminhar"),
    RECEBIDO("R", "Recebido", "Receber"),
    ARQUIVADO("A", "Arquivado", "Arquivar");

    private final String status;
    @JsonProperty
    private final String descricao;
    private final String acao;

    private Funcao(String status, String descricao, String acao) {
        this.status = status;
        this.descricao = descricao;
        this.acao = acao;
    }

    public static Funcao fromStatus(String status) {
        for (Funcao funcao : Funcao.values()) {
            if (!funcao.getStatus().equals(status)) continue;
            return funcao;
        }
        throw new IllegalArgumentException(String.format("Fun\u00e7\u00e3o n\u00e3o encontrada para o status: %s", status));
    }

    public static Funcao fromAcao(String acao) {
        for (Funcao funcao : Funcao.values()) {
            if (!funcao.getAcao().equals(acao)) continue;
            return funcao;
        }
        throw new IllegalArgumentException(String.format("Fun\u00e7\u00e3o n\u00e3o encontrada para a a\u00e7\u00e3o: %s", acao));
    }

    @JsonCreator
    public static Funcao fromDescricao(String descricao) {
        for (Funcao funcao : Funcao.values()) {
            if (!funcao.getDescricao().equalsIgnoreCase(descricao)) continue;
            return funcao;
        }
        throw new IllegalArgumentException(String.format("Fun\u00e7\u00e3o n\u00e3o encontrada para a descri\u00e7\u00e3o: %s", descricao));
    }

    public boolean isLocalRequired() {
        return this.equals((Object)ENCAMINHADO) || this.equals((Object)ARQUIVADO);
    }

    public boolean permiteSituacaoPadrao() {
        return ENCAMINHADO.equals((Object)this) || ARQUIVADO.equals((Object)this);
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getAcao() {
        return this.acao;
    }
}

