/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.folhaportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaDadosServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.service.AutonomoService;
import br.com.elotech.portaltransparencia.folhaportal.service.VencimentoDescontoServiceOxy;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class AutonomoServiceOxy
implements AutonomoService {
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;
    private final VencimentoDescontoServiceOxy vencimentoDescontoServiceOxy;

    public Page<ServidorDTO> loadAutonomos(ServidorParams params, Pageable pageable) {
        EloPage autonomos = this.integracaoFolhaPortalTransparenciaClient.getAutonomos(ServidorParamsConverter.toDTO((ServidorParams)params), pageable);
        return new PageImpl(autonomos.getContent().stream().map(ServidorDTOConverter::portalTransparenciaServidoresDTOToServidorDTO).collect(Collectors.toList()), pageable, autonomos.getTotalElements());
    }

    public Optional<ServidorDTO> loadAutonomo(ServidorParams params) {
        Long entidade = (Long)ObjectUtils.defaultIfNull((Object)params.getEntidadeAise(), (Object)params.getEntidade());
        PortalTransparenciaDadosServidorDTO dadosAutonomo = this.integracaoFolhaPortalTransparenciaClient.getDadosAutonomo(entidade, params.getExercicio(), params.getMatricula());
        if (Objects.nonNull(dadosAutonomo)) {
            return Optional.of(ServidorDTOConverter.portalTransparenciaDadosServidorDTOToServidorDTO((PortalTransparenciaDadosServidorDTO)dadosAutonomo));
        }
        return Optional.empty();
    }

    public List<ServidorVencimentosDescontosDTO> loadVencimentoEDescontos(ServidorParams params) {
        return this.vencimentoDescontoServiceOxy.getLoadVencimentoEDescontos(params);
    }

    @Generated
    public AutonomoServiceOxy(IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient, VencimentoDescontoServiceOxy vencimentoDescontoServiceOxy) {
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
        this.vencimentoDescontoServiceOxy = vencimentoDescontoServiceOxy;
    }
}

