/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.utils;

import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public final class DiariaOxyUtils {
    private static final HashMap<String, BiFunction<Sort.Order, String, Sort.Order>> ORDERS = new HashMap();
    private static final HashMap<String, BiFunction<String, String, String>> FILTERS = new HashMap();

    public static String buildSearch(FindPessoalParams params, String prefix, String tipoSolicitacao) {
        StringBuilder search = new StringBuilder();
        search.append((String)((BiFunction)FILTERS.get("tipoSolicitacao")).apply(tipoSolicitacao, prefix));
        search.append((String)((BiFunction)FILTERS.get("empenho")).apply(null, prefix));
        if (params.hasFilter().booleanValue()) {
            params.getNome().ifPresent(nome -> search.append((String)((BiFunction)FILTERS.get("nome")).apply(nome, prefix)));
            params.getDestino().ifPresent(destino -> search.append((String)((BiFunction)FILTERS.get("destino")).apply(destino, prefix)));
            params.getIdTipoObjetivoDiaria().ifPresent(idTipoObjetivo -> search.append((String)((BiFunction)FILTERS.get("objetivoDiaria")).apply(idTipoObjetivo.toString(), prefix)));
            params.getDataInicial().ifPresent(dataInicial -> search.append((String)((BiFunction)FILTERS.get("dataInicio")).apply(((LocalDate)params.getDataInicial().get()).toString(), prefix)));
            params.getDataFinal().ifPresent(dataFim -> search.append((String)((BiFunction)FILTERS.get("dataFim")).apply(((LocalDate)params.getDataFinal().get()).toString(), prefix)));
            return search.substring(1);
        }
        return search.substring(1);
    }

    public static Pageable buildSort(Pageable page) {
        ArrayList orders = new ArrayList();
        if (page.getSort().isSorted()) {
            List list = page.getSort().toList();
            list.forEach(sort -> {
                if ("empenho".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "empenho.numeroEmpenho"));
                }
                if ("nome".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "servidor.nome"));
                }
                if ("cargo".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "servidor.cargo"));
                }
                if ("matricula".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "servidor.matricula"));
                }
                if ("secretaria".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "dotacao.unidade.descricao"));
                }
                if ("dataSaida".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "dataInicio"));
                }
                if ("dataRetorno".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "dataFim"));
                }
                if ("destino".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "destinoViagem.descricao"));
                }
                if ("numeroProcesso".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "numeroProcesso"));
                }
                if ("quantidadeDiarias".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "quantidadeDiaria"));
                }
                if ("valorDiarias".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "valorDiaria"));
                }
                if ("valorTotal".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "valorTotal"));
                }
                if ("valorAnulado".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "anulacaoEmpenho.valor"));
                }
                if ("numeroSolicitacao".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "numeroSolicitacao"));
                }
                if ("prestacaoContas".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get("numeroSolicitacao")).apply(sort, "numeroSolicitacao"));
                }
                if ("dataPrestacao".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "dataPrestacaoContas"));
                }
                if ("valorEmpenho".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "empenho.valor"));
                }
            });
        }
        return PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)Sort.by(orders));
    }

    static {
        ORDERS.put("empenho", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("nome", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("cargo", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("matricula", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("secretaria", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("dataSaida", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("dataRetorno", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("destino", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("numeroProcesso", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("quantidadeDiarias", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("valorDiarias", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("valorTotal", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("valorAnulado", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("valorEmpenho", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("dataPrestacao", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("numeroSolicitacao", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        FILTERS.put("nome", (filter, prefix) -> ";servidor.nome=='*" + filter + "*'");
        FILTERS.put("destino", (filter, prefix) -> prefix + "destinoViagem.descricao=='" + filter + "*'");
        FILTERS.put("objetivoDiaria", (filter, prefix) -> prefix + "objetivoDiaria==" + filter);
        FILTERS.put("dataInicio", (filter, prefix) -> prefix + "dataInicio>=" + filter);
        FILTERS.put("dataFim", (filter, prefix) -> prefix + "dataFim<=" + filter);
        FILTERS.put("tipoSolicitacao", (filter, prefix) -> prefix + "tipoSolicitacao==" + filter);
        FILTERS.put("empenho", (filter, prefix) -> prefix + "empenho.id!=" + filter);
    }
}

