/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FindPessoalParams {
    private Long entidade;
    private Long exercicio;
    private Long empenho;
    private Long noLiquidacao;
    private String unidadeOrcamentaria;
    private String nome;
    private String cargo;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataInicial;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataFinal;
    private String destino;
    private String matricula;
    private Long prestacaoContas;
    private String exportType;
    private Long idTipoObjetivoDiaria;
    private String codigoSecretaria;
    private Long subvencao;
    private Long anoSubvencao;
    private String descricao;

    public Optional<Long> getSubvencao() {
        return Optional.ofNullable(this.subvencao);
    }

    public Optional<Long> getAnoSubvencao() {
        return Optional.ofNullable(this.anoSubvencao);
    }

    public Optional<String> getNome() {
        return Optional.ofNullable(this.nome);
    }

    public Optional<String> getDescricao() {
        return Optional.ofNullable(this.descricao);
    }

    public Optional<LocalDate> getDataInicial() {
        return Optional.ofNullable(this.dataInicial);
    }

    public Optional<LocalDate> getDataFinal() {
        return Optional.ofNullable(this.dataFinal);
    }

    public Optional<String> getDestino() {
        return Optional.ofNullable(this.destino);
    }

    public Optional<Long> getIdTipoObjetivoDiaria() {
        return Optional.ofNullable(this.idTipoObjetivoDiaria);
    }

    public Optional<String> getCargo() {
        return Optional.ofNullable(this.cargo);
    }

    public Optional<String> getCodigoSecretaria() {
        return Optional.ofNullable(this.codigoSecretaria);
    }

    public Boolean hasFilter() {
        return Objects.nonNull(this.destino) || Objects.nonNull(this.dataInicial) || Objects.nonNull(this.dataFinal) || Objects.nonNull(this.idTipoObjetivoDiaria) || Objects.nonNull(this.nome) || Objects.nonNull(this.cargo) || Objects.nonNull(this.codigoSecretaria);
    }

    public static FindPessoalParams ofParams(Long entidade, Long exercicio, Long empenho, Long noLiquidacao, String unidadeOrcamntaria, String matricula) {
        FindPessoalParams params = new FindPessoalParams();
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        params.setEmpenho(empenho);
        params.setNoLiquidacao(noLiquidacao);
        params.setUnidadeOrcamentaria(unidadeOrcamntaria);
        params.setMatricula(matricula);
        return params;
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicio(params);
        this.addEmpenho(params);
        this.addNoLiquidacao(params);
        this.addUnidadeOrcamentaria(params);
        this.addNome(params);
        this.addDataInicial(params);
        this.addDataFinal(params);
        this.addDestino(params);
        this.addMatricula(params);
        this.addPrestacaoContas(params);
        this.addTipoObjetivoDiaria(params);
        this.addCodigoSecretaria(params);
        this.addCargo(params);
        this.addAnoSubvencao(params);
        this.addSubvencao(params);
        this.addDescricao(params);
        return params;
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addEmpenho(MapSqlParameterSource params) {
        if (Objects.nonNull(this.empenho)) {
            params.addValue("empenho", (Object)this.empenho, 2);
        }
    }

    private void addNoLiquidacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.noLiquidacao)) {
            params.addValue("noLiquidacao", (Object)this.noLiquidacao, 2);
        }
    }

    private void addUnidadeOrcamentaria(MapSqlParameterSource params) {
        if (Objects.nonNull(this.unidadeOrcamentaria)) {
            params.addValue("unidadeOrcamentaria", (Object)this.unidadeOrcamentaria, 12);
        }
    }

    private void addNome(MapSqlParameterSource params) {
        if (Objects.nonNull(this.nome)) {
            params.addValue("nome", (Object)("%" + this.nome + "%"), 12);
        }
    }

    private void addDescricao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.descricao)) {
            params.addValue("descricao", (Object)("%" + this.descricao + "%"), 12);
        }
    }

    private void addDataInicial(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataInicial)) {
            params.addValue("dataInicial", (Object)Date.valueOf(this.dataInicial), 91);
        }
    }

    private void addDataFinal(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataFinal)) {
            params.addValue("dataFinal", (Object)Date.valueOf(this.dataFinal), 91);
        }
    }

    private void addDestino(MapSqlParameterSource params) {
        if (Objects.nonNull(this.destino)) {
            params.addValue("destino", (Object)("%" + this.destino + "%"), 12);
        }
    }

    private void addCargo(MapSqlParameterSource params) {
        if (Objects.nonNull(this.cargo)) {
            params.addValue("cargo", (Object)("%" + this.cargo + "%"), 12);
        }
    }

    private void addMatricula(MapSqlParameterSource params) {
        if (Objects.nonNull(this.matricula)) {
            params.addValue("matricula", (Object)this.matricula, 12);
        }
    }

    private void addPrestacaoContas(MapSqlParameterSource params) {
        if (Objects.nonNull(this.prestacaoContas)) {
            params.addValue("prestacaoContas", (Object)this.prestacaoContas, 2);
        }
    }

    private void addTipoObjetivoDiaria(MapSqlParameterSource params) {
        if (Objects.nonNull(this.idTipoObjetivoDiaria)) {
            params.addValue("idTipoObjetivoDiaria", (Object)this.idTipoObjetivoDiaria, 2);
        }
    }

    private void addCodigoSecretaria(MapSqlParameterSource params) {
        if (Objects.nonNull(this.codigoSecretaria)) {
            params.addValue("codigoSecretaria", (Object)this.codigoSecretaria, 12);
        }
    }

    private void addAnoSubvencao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.anoSubvencao)) {
            params.addValue("anoSubvencao", (Object)this.anoSubvencao, 2);
        }
    }

    private void addSubvencao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.subvencao)) {
            params.addValue("subvencao", (Object)this.subvencao, 2);
        }
    }

    @Generated
    public static FindPessoalParamsBuilder builder() {
        return new FindPessoalParamsBuilder();
    }

    @Generated
    public String toString() {
        return "FindPessoalParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", empenho=" + this.getEmpenho() + ", noLiquidacao=" + this.getNoLiquidacao() + ", unidadeOrcamentaria=" + this.getUnidadeOrcamentaria() + ", nome=" + this.getNome() + ", cargo=" + this.getCargo() + ", dataInicial=" + this.getDataInicial() + ", dataFinal=" + this.getDataFinal() + ", destino=" + this.getDestino() + ", matricula=" + this.getMatricula() + ", prestacaoContas=" + this.getPrestacaoContas() + ", exportType=" + this.getExportType() + ", idTipoObjetivoDiaria=" + this.getIdTipoObjetivoDiaria() + ", codigoSecretaria=" + this.getCodigoSecretaria() + ", subvencao=" + this.getSubvencao() + ", anoSubvencao=" + this.getAnoSubvencao() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public FindPessoalParams() {
    }

    @Generated
    public FindPessoalParams(Long entidade, Long exercicio, Long empenho, Long noLiquidacao, String unidadeOrcamentaria, String nome, String cargo, LocalDate dataInicial, LocalDate dataFinal, String destino, String matricula, Long prestacaoContas, String exportType, Long idTipoObjetivoDiaria, String codigoSecretaria, Long subvencao, Long anoSubvencao, String descricao) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.empenho = empenho;
        this.noLiquidacao = noLiquidacao;
        this.unidadeOrcamentaria = unidadeOrcamentaria;
        this.nome = nome;
        this.cargo = cargo;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        this.destino = destino;
        this.matricula = matricula;
        this.prestacaoContas = prestacaoContas;
        this.exportType = exportType;
        this.idTipoObjetivoDiaria = idTipoObjetivoDiaria;
        this.codigoSecretaria = codigoSecretaria;
        this.subvencao = subvencao;
        this.anoSubvencao = anoSubvencao;
        this.descricao = descricao;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getEmpenho() {
        return this.empenho;
    }

    @Generated
    public Long getNoLiquidacao() {
        return this.noLiquidacao;
    }

    @Generated
    public String getUnidadeOrcamentaria() {
        return this.unidadeOrcamentaria;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public Long getPrestacaoContas() {
        return this.prestacaoContas;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    @Generated
    public void setNoLiquidacao(Long noLiquidacao) {
        this.noLiquidacao = noLiquidacao;
    }

    @Generated
    public void setUnidadeOrcamentaria(String unidadeOrcamentaria) {
        this.unidadeOrcamentaria = unidadeOrcamentaria;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setDestino(String destino) {
        this.destino = destino;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setPrestacaoContas(Long prestacaoContas) {
        this.prestacaoContas = prestacaoContas;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public void setIdTipoObjetivoDiaria(Long idTipoObjetivoDiaria) {
        this.idTipoObjetivoDiaria = idTipoObjetivoDiaria;
    }

    @Generated
    public void setCodigoSecretaria(String codigoSecretaria) {
        this.codigoSecretaria = codigoSecretaria;
    }

    @Generated
    public void setSubvencao(Long subvencao) {
        this.subvencao = subvencao;
    }

    @Generated
    public void setAnoSubvencao(Long anoSubvencao) {
        this.anoSubvencao = anoSubvencao;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindPessoalParams)) {
            return false;
        }
        FindPessoalParams other = (FindPessoalParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$empenho = this.getEmpenho();
        Long other$empenho = other.getEmpenho();
        if (this$empenho == null ? other$empenho != null : !((Object)this$empenho).equals(other$empenho)) {
            return false;
        }
        Long this$noLiquidacao = this.getNoLiquidacao();
        Long other$noLiquidacao = other.getNoLiquidacao();
        if (this$noLiquidacao == null ? other$noLiquidacao != null : !((Object)this$noLiquidacao).equals(other$noLiquidacao)) {
            return false;
        }
        String this$unidadeOrcamentaria = this.getUnidadeOrcamentaria();
        String other$unidadeOrcamentaria = other.getUnidadeOrcamentaria();
        if (this$unidadeOrcamentaria == null ? other$unidadeOrcamentaria != null : !this$unidadeOrcamentaria.equals(other$unidadeOrcamentaria)) {
            return false;
        }
        Optional this$nome = this.getNome();
        Optional other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !((Object)this$nome).equals(other$nome)) {
            return false;
        }
        Optional this$cargo = this.getCargo();
        Optional other$cargo = other.getCargo();
        if (this$cargo == null ? other$cargo != null : !((Object)this$cargo).equals(other$cargo)) {
            return false;
        }
        Optional this$dataInicial = this.getDataInicial();
        Optional other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        Optional this$dataFinal = this.getDataFinal();
        Optional other$dataFinal = other.getDataFinal();
        if (this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal)) {
            return false;
        }
        Optional this$destino = this.getDestino();
        Optional other$destino = other.getDestino();
        if (this$destino == null ? other$destino != null : !((Object)this$destino).equals(other$destino)) {
            return false;
        }
        String this$matricula = this.getMatricula();
        String other$matricula = other.getMatricula();
        if (this$matricula == null ? other$matricula != null : !this$matricula.equals(other$matricula)) {
            return false;
        }
        Long this$prestacaoContas = this.getPrestacaoContas();
        Long other$prestacaoContas = other.getPrestacaoContas();
        if (this$prestacaoContas == null ? other$prestacaoContas != null : !((Object)this$prestacaoContas).equals(other$prestacaoContas)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        if (this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType)) {
            return false;
        }
        Optional this$idTipoObjetivoDiaria = this.getIdTipoObjetivoDiaria();
        Optional other$idTipoObjetivoDiaria = other.getIdTipoObjetivoDiaria();
        if (this$idTipoObjetivoDiaria == null ? other$idTipoObjetivoDiaria != null : !((Object)this$idTipoObjetivoDiaria).equals(other$idTipoObjetivoDiaria)) {
            return false;
        }
        Optional this$codigoSecretaria = this.getCodigoSecretaria();
        Optional other$codigoSecretaria = other.getCodigoSecretaria();
        if (this$codigoSecretaria == null ? other$codigoSecretaria != null : !((Object)this$codigoSecretaria).equals(other$codigoSecretaria)) {
            return false;
        }
        Optional this$subvencao = this.getSubvencao();
        Optional other$subvencao = other.getSubvencao();
        if (this$subvencao == null ? other$subvencao != null : !((Object)this$subvencao).equals(other$subvencao)) {
            return false;
        }
        Optional this$anoSubvencao = this.getAnoSubvencao();
        Optional other$anoSubvencao = other.getAnoSubvencao();
        if (this$anoSubvencao == null ? other$anoSubvencao != null : !((Object)this$anoSubvencao).equals(other$anoSubvencao)) {
            return false;
        }
        Optional this$descricao = this.getDescricao();
        Optional other$descricao = other.getDescricao();
        return !(this$descricao == null ? other$descricao != null : !((Object)this$descricao).equals(other$descricao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindPessoalParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $empenho = this.getEmpenho();
        result = result * 59 + ($empenho == null ? 43 : ((Object)$empenho).hashCode());
        Long $noLiquidacao = this.getNoLiquidacao();
        result = result * 59 + ($noLiquidacao == null ? 43 : ((Object)$noLiquidacao).hashCode());
        String $unidadeOrcamentaria = this.getUnidadeOrcamentaria();
        result = result * 59 + ($unidadeOrcamentaria == null ? 43 : $unidadeOrcamentaria.hashCode());
        Optional $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : ((Object)$nome).hashCode());
        Optional $cargo = this.getCargo();
        result = result * 59 + ($cargo == null ? 43 : ((Object)$cargo).hashCode());
        Optional $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        Optional $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        Optional $destino = this.getDestino();
        result = result * 59 + ($destino == null ? 43 : ((Object)$destino).hashCode());
        String $matricula = this.getMatricula();
        result = result * 59 + ($matricula == null ? 43 : $matricula.hashCode());
        Long $prestacaoContas = this.getPrestacaoContas();
        result = result * 59 + ($prestacaoContas == null ? 43 : ((Object)$prestacaoContas).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        Optional $idTipoObjetivoDiaria = this.getIdTipoObjetivoDiaria();
        result = result * 59 + ($idTipoObjetivoDiaria == null ? 43 : ((Object)$idTipoObjetivoDiaria).hashCode());
        Optional $codigoSecretaria = this.getCodigoSecretaria();
        result = result * 59 + ($codigoSecretaria == null ? 43 : ((Object)$codigoSecretaria).hashCode());
        Optional $subvencao = this.getSubvencao();
        result = result * 59 + ($subvencao == null ? 43 : ((Object)$subvencao).hashCode());
        Optional $anoSubvencao = this.getAnoSubvencao();
        result = result * 59 + ($anoSubvencao == null ? 43 : ((Object)$anoSubvencao).hashCode());
        Optional $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : ((Object)$descricao).hashCode());
        return result;
    }
}

