/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.CreditosAdicionaisDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.CreditosAdicionaisParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CreditosAdicionaisRepository {
    private static final String CREDITOSADICIONAIS = "db/sql/contab/creditosAdicionais.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public CreditosAdicionaisRepository(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<CreditosAdicionaisDTO> findCreditosAdicionais(CreditosAdicionaisParams params, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)CREDITOSADICIONAIS);
        sql = this.sqlCreditosAdicionais(params, sql);
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(SqlUtils.createSQLCount((String)sql), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)sql, (String)this.datasourceWrapper.getPlatform());
        List lista = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(CreditosAdicionaisDTO.class));
        return new PageImpl(lista, pageable, total.longValue());
    }

    public String sqlCreditosAdicionais(CreditosAdicionaisParams params, String sql) {
        StringBuilder filtro = new StringBuilder();
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(params.getDespesa())) {
            filtro.append(SqlUtils.andLike((String)"${db.contabilidade.schema}", (String)"DESPESA", (String)params.getDespesa()));
        }
        if (Objects.nonNull(params.getNroDecreto())) {
            where.append(SqlUtils.andBeginsWith((String)"${db.contabilidade.schema}", (String)"NRO_DECRETO", (String)params.getNroDecreto()));
        }
        return sql.replace("$[FILTRO]", filtro).replace("$[WHERE]", where);
    }
}

