/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.domain.dto;

import br.com.elotech.portaltransparencia.exception.EntidadeComprasOxyException;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import java.util.Objects;
import lombok.Generated;

public class EntidadeComprasDTO {
    private Long id;
    private String nome;
    private String cnpj;
    private Long logradouro;
    private Long cidade;
    private String uf;
    private String cep;
    private String entidadePrincipal;
    private String tipoEntidade;
    private String telefone;

    public static EntidadeComprasDTO fromEntidadeComprasOxy(EntidadeDTO entidadeDTO) {
        if (Objects.isNull(entidadeDTO)) {
            throw new EntidadeComprasOxyException("N\u00e3o foi poss\u00edvel converter para entidade do compras.");
        }
        EntidadeComprasDTO entidadeCompras = new EntidadeComprasDTO();
        entidadeCompras.setId(entidadeDTO.getId());
        entidadeCompras.setNome(entidadeDTO.getNome());
        entidadeCompras.setCnpj(entidadeDTO.getCnpj());
        entidadeCompras.setEntidadePrincipal(Boolean.TRUE.equals(entidadeDTO.getEntidadePrincipal()) ? "S" : "N");
        entidadeCompras.setTipoEntidade(entidadeDTO.getTipo().getDescricao());
        entidadeCompras.setUf(entidadeDTO.getSiglaUF());
        return entidadeCompras;
    }

    @Generated
    public EntidadeComprasDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getCnpj() {
        return this.cnpj;
    }

    @Generated
    public Long getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public Long getCidade() {
        return this.cidade;
    }

    @Generated
    public String getUf() {
        return this.uf;
    }

    @Generated
    public String getCep() {
        return this.cep;
    }

    @Generated
    public String getEntidadePrincipal() {
        return this.entidadePrincipal;
    }

    @Generated
    public String getTipoEntidade() {
        return this.tipoEntidade;
    }

    @Generated
    public String getTelefone() {
        return this.telefone;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Generated
    public void setLogradouro(Long logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setCidade(Long cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setUf(String uf) {
        this.uf = uf;
    }

    @Generated
    public void setCep(String cep) {
        this.cep = cep;
    }

    @Generated
    public void setEntidadePrincipal(String entidadePrincipal) {
        this.entidadePrincipal = entidadePrincipal;
    }

    @Generated
    public void setTipoEntidade(String tipoEntidade) {
        this.tipoEntidade = tipoEntidade;
    }

    @Generated
    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntidadeComprasDTO)) {
            return false;
        }
        EntidadeComprasDTO other = (EntidadeComprasDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$cnpj = this.getCnpj();
        String other$cnpj = other.getCnpj();
        if (this$cnpj == null ? other$cnpj != null : !this$cnpj.equals(other$cnpj)) {
            return false;
        }
        Long this$logradouro = this.getLogradouro();
        Long other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !((Object)this$logradouro).equals(other$logradouro)) {
            return false;
        }
        Long this$cidade = this.getCidade();
        Long other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !((Object)this$cidade).equals(other$cidade)) {
            return false;
        }
        String this$uf = this.getUf();
        String other$uf = other.getUf();
        if (this$uf == null ? other$uf != null : !this$uf.equals(other$uf)) {
            return false;
        }
        String this$cep = this.getCep();
        String other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !this$cep.equals(other$cep)) {
            return false;
        }
        String this$entidadePrincipal = this.getEntidadePrincipal();
        String other$entidadePrincipal = other.getEntidadePrincipal();
        if (this$entidadePrincipal == null ? other$entidadePrincipal != null : !this$entidadePrincipal.equals(other$entidadePrincipal)) {
            return false;
        }
        String this$tipoEntidade = this.getTipoEntidade();
        String other$tipoEntidade = other.getTipoEntidade();
        if (this$tipoEntidade == null ? other$tipoEntidade != null : !this$tipoEntidade.equals(other$tipoEntidade)) {
            return false;
        }
        String this$telefone = this.getTelefone();
        String other$telefone = other.getTelefone();
        return !(this$telefone == null ? other$telefone != null : !this$telefone.equals(other$telefone));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntidadeComprasDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $cnpj = this.getCnpj();
        result = result * 59 + ($cnpj == null ? 43 : $cnpj.hashCode());
        Long $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : ((Object)$logradouro).hashCode());
        Long $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : ((Object)$cidade).hashCode());
        String $uf = this.getUf();
        result = result * 59 + ($uf == null ? 43 : $uf.hashCode());
        String $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : $cep.hashCode());
        String $entidadePrincipal = this.getEntidadePrincipal();
        result = result * 59 + ($entidadePrincipal == null ? 43 : $entidadePrincipal.hashCode());
        String $tipoEntidade = this.getTipoEntidade();
        result = result * 59 + ($tipoEntidade == null ? 43 : $tipoEntidade.hashCode());
        String $telefone = this.getTelefone();
        result = result * 59 + ($telefone == null ? 43 : $telefone.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntidadeComprasDTO(id=" + this.getId() + ", nome=" + this.getNome() + ", cnpj=" + this.getCnpj() + ", logradouro=" + this.getLogradouro() + ", cidade=" + this.getCidade() + ", uf=" + this.getUf() + ", cep=" + this.getCep() + ", entidadePrincipal=" + this.getEntidadePrincipal() + ", tipoEntidade=" + this.getTipoEntidade() + ", telefone=" + this.getTelefone() + ")";
    }
}

