/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.Publicacao;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupo;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoSubGrupo;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoSubGrupoExercicio;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PublicacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.PublicacaoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PublicacaoParams;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PublicacaoRepositoryImpl
implements PublicacaoRepository {
    private static final String FILTRO_TIPO_PUBLICACAO = "$[filtroTipoPublicacao]";
    private static final String PUBLICACOES_SQL = "db/sql/contab/publicacoes.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final EntidadeContabilidadeService entidadeService;

    @Autowired
    public PublicacaoRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeContabilidadeService entidadeService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeService = entidadeService;
    }

    public List<PublicacaoGrupo> loadPublicacoes(PublicacaoParams publicacaoParams, String nomeSchemaEloArquivo) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)PUBLICACOES_SQL).replace(FILTRO_TIPO_PUBLICACAO, " ").replace("= :entidade", this.entidadeService.resolveWhereSQL(publicacaoParams.getEntidade())).replace("schema_eloarquivo", nomeSchemaEloArquivo));
        List listaPublicacoesDTO = this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)publicacaoParams.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PublicacaoDTO.class));
        return this.createListPublicacaoGrupo(publicacaoParams, listaPublicacoesDTO);
    }

    private List<PublicacaoGrupo> createListPublicacaoGrupo(PublicacaoParams publicacaoParams, List<PublicacaoDTO> listaPublicacoesDTO) {
        ArrayList<PublicacaoGrupo> listGrupo = new ArrayList<PublicacaoGrupo>();
        PublicacaoGrupo grupo = new PublicacaoGrupo();
        PublicacaoSubGrupo subGrupo = new PublicacaoSubGrupo();
        PublicacaoSubGrupoExercicio subGrupoExercicio = new PublicacaoSubGrupoExercicio();
        Publicacao publicacao = new Publicacao();
        for (PublicacaoDTO publicacaoDTO : listaPublicacoesDTO) {
            if (this.isPublicacaoGrupo(grupo, publicacaoDTO)) {
                grupo = this.createPublicacaoGrupo(publicacaoDTO);
                listGrupo.add(grupo);
            }
            if (this.isPublicacaoSubGrupo(subGrupo, publicacaoDTO)) {
                subGrupo = this.createPublicacaoSubGrupo(publicacaoDTO);
                subGrupoExercicio = this.createPublicacaoSubGrupoExercicio(publicacaoParams, subGrupo, publicacaoDTO);
                grupo.getSubGrupo().add(subGrupoExercicio);
            }
            if (!this.isPublicacao(publicacao, publicacaoDTO)) continue;
            publicacao = this.createPublicacao(publicacaoParams, publicacaoDTO);
            subGrupoExercicio.getPublicacoes().add(publicacao);
        }
        return listGrupo;
    }

    private PublicacaoSubGrupoExercicio createPublicacaoSubGrupoExercicio(PublicacaoParams publicacaoParams, PublicacaoSubGrupo subGrupo, PublicacaoDTO publicacaoDTO) {
        PublicacaoSubGrupoExercicio subGrupoExercicio = new PublicacaoSubGrupoExercicio();
        subGrupoExercicio.setPublicacoes(new ArrayList());
        subGrupoExercicio.setEntidade(publicacaoParams.getEntidade());
        subGrupoExercicio.setExercicio(publicacaoParams.getExercicio());
        subGrupoExercicio.setId(publicacaoDTO.getIdSubGrupoExercicio());
        subGrupoExercicio.setMostraWeb(publicacaoDTO.getMostraWeb());
        subGrupoExercicio.setSubGrupoRelatorio(subGrupo);
        return subGrupoExercicio;
    }

    private PublicacaoSubGrupo createPublicacaoSubGrupo(PublicacaoDTO publicacaoDTO) {
        PublicacaoSubGrupo subGrupo = new PublicacaoSubGrupo();
        subGrupo.setId(publicacaoDTO.getIdSubGrupo());
        subGrupo.setDescricao(publicacaoDTO.getDescricaoSubGrupo());
        return subGrupo;
    }

    private boolean isPublicacaoSubGrupo(PublicacaoSubGrupo subGrupo, PublicacaoDTO publicacaoDTO) {
        return publicacaoDTO.getIdSubGrupoExercicio() != null && (subGrupo.getId() == null || !subGrupo.getId().equals(publicacaoDTO.getIdSubGrupo()));
    }

    private PublicacaoGrupo createPublicacaoGrupo(PublicacaoDTO publicacaoDTO) {
        PublicacaoGrupo grupo = new PublicacaoGrupo();
        grupo.setSubGrupo(new ArrayList());
        grupo.setId(publicacaoDTO.getId());
        grupo.setDescricao(publicacaoDTO.getDescricao());
        grupo.setFiltrarPorExercicio(publicacaoDTO.getFiltrarPorExercicio());
        grupo.setMostraWeb(publicacaoDTO.getMostraWeb());
        return grupo;
    }

    private boolean isPublicacaoGrupo(PublicacaoGrupo grupo, PublicacaoDTO publicacaoDTO) {
        return grupo.getId() == null || !grupo.getId().equals(publicacaoDTO.getId());
    }

    private Publicacao createPublicacao(PublicacaoParams publicacaoParams, PublicacaoDTO publicacaoDTO) {
        Publicacao publicacao = new Publicacao();
        publicacao.setId(publicacaoDTO.getIdPublicacao());
        publicacao.setEntidade(publicacaoParams.getEntidade());
        publicacao.setExercicio(publicacaoParams.getExercicio());
        publicacao.setDescricao(publicacaoDTO.getDescricaoPublicacao());
        publicacao.setNomeArquivo(publicacaoDTO.getNomeArquivo());
        publicacao.setTipoPeriodo(publicacaoDTO.getTipoPeriodo());
        publicacao.setResumo(publicacaoDTO.getResumo());
        publicacao.setIdArquivo(publicacaoDTO.getIdArquivo());
        publicacao.setLink(publicacaoDTO.getLink());
        publicacao.setTamanhoArquivo(publicacaoDTO.getTamanhoArquivo());
        publicacao.setDataArquivo(publicacaoDTO.getDataArquivo());
        return publicacao;
    }

    private boolean isPublicacao(Publicacao publicacao, PublicacaoDTO publicacaoDTO) {
        return publicacaoDTO.getIdPublicacao() != null && (publicacao.getId() == null || !publicacao.getId().equals(publicacaoDTO.getIdPublicacao()));
    }

    public List<PublicacaoGrupo> loadPublicacoesGrupo(PublicacaoParams publicacaoParams, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)PUBLICACOES_SQL).replace("= :entidade", this.entidadeService.resolveWhereSQL(publicacaoParams.getEntidade()));
        StringBuilder filtro = new StringBuilder();
        filtro.append(" AND G.ID = :idGrupo ");
        publicacaoParams.getIdSubGrupo().ifPresent(item -> filtro.append(" AND SG.ID = :idSubGrupo"));
        StringBuilder query = new StringBuilder(sql.replace(FILTRO_TIPO_PUBLICACAO, filtro).replace("schema_eloarquivo", nomeSchemaEloArquivo));
        List listaPublicacoesDTO = this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)publicacaoParams.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PublicacaoDTO.class));
        return this.createListPublicacaoGrupo(publicacaoParams, listaPublicacoesDTO);
    }
}

