/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.portaltransparencia.protocportal.domain.Local;
import br.com.elotech.portaltransparencia.protocportal.domain.Processo;
import br.com.elotech.portaltransparencia.protocportal.domain.Situacao;
import br.com.elotech.portaltransparencia.protocportal.domain.TramitePK;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="protocolo.tramitacao")
public class Tramite
implements EloEntity<TramitePK> {
    public static final String PARECER_RECEBIMENTO_AUTOMATICO = "Recebido Automaticamente no Encerramento do Processo";
    @EmbeddedId
    private TramitePK id = new TramitePK();
    @ManyToOne
    private Situacao situacao;
    @Size(max=1)
    private @Size(max=1) String funcao;
    private LocalDate data;
    private LocalDateTime hora;
    private String parecer;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="local", referencedColumnName="codigo"))})
    @NotFound(action=NotFoundAction.IGNORE)
    private Local local;
    @Column(name="USUARIOREG")
    private String usuarioRegistro;
    @Column(name="DATAREG")
    private LocalDate dataRegistro;
    @Column(name="CAIXA")
    private String caixaLegado;

    public Tramite() {
        this.id = new TramitePK();
    }

    public Tramite(TramitePK id, Processo processo, String funcao, Local local) {
        this.id = id;
        this.data = processo.getDataOrigem();
        this.hora = processo.getHoraOrigem();
        this.situacao = processo.getSituacao();
        this.local = local;
        this.funcao = funcao;
    }

    public TramitePK getId() {
        return this.id;
    }

    public void setId(TramitePK id) {
        this.id = id;
    }

    public Situacao getSituacao() {
        return this.situacao;
    }

    public void setSituacao(Situacao situacao) {
        this.situacao = situacao;
    }

    public String getFuncao() {
        return this.funcao;
    }

    public void setFuncao(String funcao) {
        this.funcao = funcao;
    }

    public LocalDate getData() {
        return this.data;
    }

    public void setData(LocalDate data) {
        this.data = data;
    }

    public LocalDateTime getHora() {
        return this.hora;
    }

    public void setHora(LocalDateTime hora) {
        this.hora = hora;
    }

    public String getParecer() {
        return this.parecer;
    }

    public void setParecer(String parecer) {
        this.parecer = parecer;
    }

    public Local getLocal() {
        return this.local;
    }

    public void setLocal(Local local) {
        this.local = local;
    }

    public String getUsuarioRegistro() {
        return this.usuarioRegistro;
    }

    public void setUsuarioRegistro(String usuarioRegistro) {
        this.usuarioRegistro = usuarioRegistro;
    }

    public LocalDate getDataRegistro() {
        return this.dataRegistro;
    }

    public void setDataRegistro(LocalDate dataRegistro) {
        this.dataRegistro = dataRegistro;
    }

    public String getCaixaLegado() {
        return this.caixaLegado;
    }

    public void setCaixaLegado(String caixaLegado) {
        this.caixaLegado = caixaLegado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tramite)) {
            return false;
        }
        Tramite other = (Tramite)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TramitePK this$id = this.getId();
        TramitePK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Tramite;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TramitePK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Tramite(id=" + this.getId() + ", situacao=" + this.getSituacao() + ", data=" + this.getData() + ", parecer=" + this.getParecer() + ")";
    }
}

