/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.folhaportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaDadosServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.EstagiarioDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.service.EstagiarioService;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class EstagiarioServiceOxy
implements EstagiarioService {
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;

    public Page<EstagiarioDTO> loadEstagiarios(ServidorParams params, Pageable pageable) {
        EloPage estagiarios = this.integracaoFolhaPortalTransparenciaClient.getEstagiarios(ServidorParamsConverter.toDTO((ServidorParams)params), pageable);
        return new PageImpl(estagiarios.getContent().stream().map(EstagiarioDTOConverter::portalTransparenciaServidoresDTOToEstagiarioDTO).collect(Collectors.toList()), pageable, estagiarios.getTotalElements());
    }

    public Optional<EstagiarioDTO> loadEstagiario(ServidorParams params) {
        Long entidade = (Long)ObjectUtils.defaultIfNull((Object)params.getEntidadeAise(), (Object)params.getEntidade());
        return Optional.of(EstagiarioDTOConverter.portalTransparenciaDadosServidorDTOToEstagiarioDTO((PortalTransparenciaDadosServidorDTO)this.integracaoFolhaPortalTransparenciaClient.getDadosEstagiario(entidade, params.getExercicio(), params.getMatricula())));
    }

    @Generated
    public EstagiarioServiceOxy(IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient) {
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
    }
}

