/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.contabportal.domain.dto.DespesaDetalhadaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DespesaPorNivelDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.DespesaPorNivelRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.DespesaParams;
import java.util.List;
import lombok.Generated;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DespesaPorNivelService {
    private final DespesaPorNivelRepository despesaPorNivelRepository;

    @Cacheable(value={"despesas"})
    public List<DespesaPorNivelDTO> getDespesaPorNivel(Long entidade, Long exercicio, String nivelLei, String tipo) {
        return this.despesaPorNivelRepository.getDespesaPorNivel(entidade, exercicio, nivelLei, tipo);
    }

    public List<DespesaPorNivelDTO> getDespesaPorFonteRecurso(Long entidade, Long exercicio) {
        return this.despesaPorNivelRepository.getDespesaPorFonteRecurso(entidade, exercicio);
    }

    public List<DespesaPorNivelDTO> getDespesaPorEsferaAdministrativa(Long entidade, Long exercicio) {
        return this.despesaPorNivelRepository.getDespesaPorEsferaAdministrativa(entidade, exercicio);
    }

    public List<DespesaDetalhadaDTO> getDepesaDetalhada(Long entidade, Long exercicio) {
        return this.despesaPorNivelRepository.getDepesaDetalhada(entidade, exercicio);
    }

    public List<DespesaDetalhadaDTO> getDepesaAgrupaNivel(DespesaParams params) {
        return this.despesaPorNivelRepository.getDepesaAgrupaNivel(params);
    }

    @Generated
    public DespesaPorNivelService(DespesaPorNivelRepository despesaPorNivelRepository) {
        this.despesaPorNivelRepository = despesaPorNivelRepository;
    }
}

