/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource.params;

import br.com.elotech.oxy.adm.compras.client.portal.FindContratoParamsDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FindContratoParams {
    private static final int DIAINICIAL = 1;
    private static final int MESINICIAL = 1;
    private static final int ANOINICIAL = 1900;
    private Long entidade;
    private Long exercicio;
    private String tipoContrato;
    private String contrato;
    private Long numeroContrato;
    private String dataAtual;
    private Long sequencia;
    private String nome;
    private Long exercicioContrato;
    private Long exercicioLicitacao;
    private Long numeroLicitacao;
    private Long tipoLicitacao;
    private String dataInicialAssinatura;
    private String dataFinalAssinatura;
    private Long idContrato;
    private String rateio;
    private String isCovid;
    private Long tipoAto;
    private String exportType;

    public Optional<Long> getExercicio() {
        return Optional.ofNullable(this.exercicio);
    }

    public Optional<String> getTipoContrato() {
        return Optional.ofNullable(this.tipoContrato);
    }

    public Optional<String> getDataFinalAssinatura() {
        return Optional.ofNullable(this.dataFinalAssinatura);
    }

    public Optional<String> getDataInicialAssinatura() {
        return Optional.ofNullable(this.dataInicialAssinatura);
    }

    public Optional<String> getContrato() {
        return Optional.ofNullable(this.contrato);
    }

    public Optional<Long> getNumeroContrato() {
        return Optional.ofNullable(this.numeroContrato);
    }

    public Optional<String> getNome() {
        return Optional.ofNullable(this.nome);
    }

    public Optional<Long> getTipoLicitacao() {
        return Optional.ofNullable(this.tipoLicitacao);
    }

    public Optional<Long> getNumeroLicitacao() {
        return Optional.ofNullable(this.numeroLicitacao);
    }

    public Optional<Long> getExercicioLicitacao() {
        return Optional.ofNullable(this.exercicioLicitacao);
    }

    public Optional<Long> getExercicioContrato() {
        return Optional.ofNullable(this.exercicioContrato);
    }

    public Optional<Long> getIdContrato() {
        return Optional.ofNullable(this.idContrato);
    }

    public Optional<String> getRateio() {
        return Optional.ofNullable(this.rateio);
    }

    public Optional<String> getisCovid() {
        return Optional.ofNullable(this.isCovid);
    }

    public Optional<Long> getTipoAto() {
        return Optional.ofNullable(this.tipoAto);
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicios(params);
        this.addTipoContrato(params);
        this.addContrato(params);
        this.addNumeroContrato(params);
        this.addDatas(params);
        this.addSequencia(params);
        this.addNome(params);
        this.addTipoLicitacao(params);
        this.addNumeroLicitacao(params);
        this.addDataInicialAssinatura(params);
        this.addDataFinalAssinatura(params);
        this.addIdContrato(params);
        this.addRateio(params);
        this.addTipoAto(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addDataInicialAssinatura(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataInicialAssinatura)) {
            params.addValue("dataInicialAssinatura", (Object)this.dataInicialAssinatura, 91);
        }
    }

    private void addDataFinalAssinatura(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataFinalAssinatura)) {
            params.addValue("dataFinalAssinatura", (Object)this.dataFinalAssinatura, 91);
        }
    }

    private void addExercicios(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
        if (Objects.nonNull(this.exercicioLicitacao)) {
            params.addValue("exercicioLicitacao", (Object)this.exercicioLicitacao, 2);
        }
        if (Objects.nonNull(this.exercicioContrato)) {
            params.addValue("exercicioContrato", (Object)this.exercicioContrato, 2);
        }
    }

    private void addTipoContrato(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoContrato)) {
            params.addValue("tipoContrato", (Object)this.tipoContrato, 12);
        }
    }

    private void addContrato(MapSqlParameterSource params) {
        params.addValue("contrato", (Object)this.contrato, 2);
    }

    private void addNumeroContrato(MapSqlParameterSource params) {
        params.addValue("numeroContrato", (Object)this.numeroContrato, 2);
    }

    private void addDatas(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataAtual)) {
            params.addValue("dataAtual", (Object)this.dataAtual, 91);
        } else {
            params.addValue("dataAtual", (Object)new Date(), 91);
        }
        Calendar dataZero = Calendar.getInstance();
        dataZero.set(1900, 1, 1);
        params.addValue("dataZero", (Object)dataZero.getTime());
    }

    private void addSequencia(MapSqlParameterSource params) {
        params.addValue("sequencia", (Object)this.sequencia, 2);
    }

    private void addNome(MapSqlParameterSource params) {
        if (Objects.nonNull(this.nome)) {
            params.addValue("nome", (Object)("%" + this.nome + "%"), 12);
        }
    }

    private void addTipoLicitacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoLicitacao)) {
            params.addValue("tipoLicitacao", (Object)this.tipoLicitacao, 2);
        }
    }

    private void addNumeroLicitacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numeroLicitacao)) {
            params.addValue("numeroLicitacao", (Object)this.numeroLicitacao, 2);
        }
    }

    private void addIdContrato(MapSqlParameterSource params) {
        if (Objects.nonNull(this.idContrato)) {
            params.addValue("idContrato", (Object)this.idContrato, 2);
        }
    }

    private void addRateio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.rateio)) {
            params.addValue("rateio", (Object)this.rateio, 12);
        }
    }

    private void addTipoAto(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoAto)) {
            params.addValue("tipoAto", (Object)this.tipoAto, 2);
        }
    }

    public FindContratoParamsDTO toComprasOxyParams() {
        FindContratoParamsDTO params = new FindContratoParamsDTO();
        params.setEntidade(this.entidade);
        params.setExercicio(this.exercicio);
        params.setTipoContrato(this.tipoContrato);
        params.setContrato(this.contrato);
        params.setNumeroContrato(this.numeroContrato);
        params.setDataAtual(this.dataAtual);
        params.setSequencia(this.sequencia);
        params.setNome(this.nome);
        params.setExercicioContrato(this.exercicioContrato);
        params.setExercicioLicitacao(this.exercicioLicitacao);
        params.setNumeroLicitacao(this.numeroLicitacao);
        params.setTipoLicitacao(this.tipoLicitacao);
        params.setDataInicialAssinatura(this.dataInicialAssinatura);
        params.setDataFinalAssinatura(this.dataFinalAssinatura);
        params.setIdContrato(this.idContrato);
        params.setRateio(this.rateio);
        params.setIsCovid(this.isCovid);
        params.setTipoAto(this.tipoAto);
        params.setExportType(this.exportType);
        return params;
    }

    @Generated
    public static FindContratoParamsBuilder builder() {
        return new FindContratoParamsBuilder();
    }

    @Generated
    public String toString() {
        return "FindContratoParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoContrato=" + this.getTipoContrato() + ", contrato=" + this.getContrato() + ", numeroContrato=" + this.getNumeroContrato() + ", dataAtual=" + this.getDataAtual() + ", sequencia=" + this.getSequencia() + ", nome=" + this.getNome() + ", exercicioContrato=" + this.getExercicioContrato() + ", exercicioLicitacao=" + this.getExercicioLicitacao() + ", numeroLicitacao=" + this.getNumeroLicitacao() + ", tipoLicitacao=" + this.getTipoLicitacao() + ", dataInicialAssinatura=" + this.getDataInicialAssinatura() + ", dataFinalAssinatura=" + this.getDataFinalAssinatura() + ", idContrato=" + this.getIdContrato() + ", rateio=" + this.getRateio() + ", isCovid=" + this.getisCovid() + ", tipoAto=" + this.getTipoAto() + ", exportType=" + this.getExportType() + ")";
    }

    @Generated
    public FindContratoParams(Long entidade, Long exercicio, String tipoContrato, String contrato, Long numeroContrato, String dataAtual, Long sequencia, String nome, Long exercicioContrato, Long exercicioLicitacao, Long numeroLicitacao, Long tipoLicitacao, String dataInicialAssinatura, String dataFinalAssinatura, Long idContrato, String rateio, String isCovid, Long tipoAto, String exportType) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.tipoContrato = tipoContrato;
        this.contrato = contrato;
        this.numeroContrato = numeroContrato;
        this.dataAtual = dataAtual;
        this.sequencia = sequencia;
        this.nome = nome;
        this.exercicioContrato = exercicioContrato;
        this.exercicioLicitacao = exercicioLicitacao;
        this.numeroLicitacao = numeroLicitacao;
        this.tipoLicitacao = tipoLicitacao;
        this.dataInicialAssinatura = dataInicialAssinatura;
        this.dataFinalAssinatura = dataFinalAssinatura;
        this.idContrato = idContrato;
        this.rateio = rateio;
        this.isCovid = isCovid;
        this.tipoAto = tipoAto;
        this.exportType = exportType;
    }

    @Generated
    public FindContratoParams() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getDataAtual() {
        return this.dataAtual;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoContrato(String tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    @Generated
    public void setContrato(String contrato) {
        this.contrato = contrato;
    }

    @Generated
    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @Generated
    public void setDataAtual(String dataAtual) {
        this.dataAtual = dataAtual;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setExercicioContrato(Long exercicioContrato) {
        this.exercicioContrato = exercicioContrato;
    }

    @Generated
    public void setExercicioLicitacao(Long exercicioLicitacao) {
        this.exercicioLicitacao = exercicioLicitacao;
    }

    @Generated
    public void setNumeroLicitacao(Long numeroLicitacao) {
        this.numeroLicitacao = numeroLicitacao;
    }

    @Generated
    public void setTipoLicitacao(Long tipoLicitacao) {
        this.tipoLicitacao = tipoLicitacao;
    }

    @Generated
    public void setDataInicialAssinatura(String dataInicialAssinatura) {
        this.dataInicialAssinatura = dataInicialAssinatura;
    }

    @Generated
    public void setDataFinalAssinatura(String dataFinalAssinatura) {
        this.dataFinalAssinatura = dataFinalAssinatura;
    }

    @Generated
    public void setIdContrato(Long idContrato) {
        this.idContrato = idContrato;
    }

    @Generated
    public void setRateio(String rateio) {
        this.rateio = rateio;
    }

    @Generated
    public void setIsCovid(String isCovid) {
        this.isCovid = isCovid;
    }

    @Generated
    public void setTipoAto(Long tipoAto) {
        this.tipoAto = tipoAto;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindContratoParams)) {
            return false;
        }
        FindContratoParams other = (FindContratoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Optional this$exercicio = this.getExercicio();
        Optional other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Optional this$tipoContrato = this.getTipoContrato();
        Optional other$tipoContrato = other.getTipoContrato();
        if (this$tipoContrato == null ? other$tipoContrato != null : !((Object)this$tipoContrato).equals(other$tipoContrato)) {
            return false;
        }
        Optional this$contrato = this.getContrato();
        Optional other$contrato = other.getContrato();
        if (this$contrato == null ? other$contrato != null : !((Object)this$contrato).equals(other$contrato)) {
            return false;
        }
        Optional this$numeroContrato = this.getNumeroContrato();
        Optional other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !((Object)this$numeroContrato).equals(other$numeroContrato)) {
            return false;
        }
        String this$dataAtual = this.getDataAtual();
        String other$dataAtual = other.getDataAtual();
        if (this$dataAtual == null ? other$dataAtual != null : !this$dataAtual.equals(other$dataAtual)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Optional this$nome = this.getNome();
        Optional other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !((Object)this$nome).equals(other$nome)) {
            return false;
        }
        Optional this$exercicioContrato = this.getExercicioContrato();
        Optional other$exercicioContrato = other.getExercicioContrato();
        if (this$exercicioContrato == null ? other$exercicioContrato != null : !((Object)this$exercicioContrato).equals(other$exercicioContrato)) {
            return false;
        }
        Optional this$exercicioLicitacao = this.getExercicioLicitacao();
        Optional other$exercicioLicitacao = other.getExercicioLicitacao();
        if (this$exercicioLicitacao == null ? other$exercicioLicitacao != null : !((Object)this$exercicioLicitacao).equals(other$exercicioLicitacao)) {
            return false;
        }
        Optional this$numeroLicitacao = this.getNumeroLicitacao();
        Optional other$numeroLicitacao = other.getNumeroLicitacao();
        if (this$numeroLicitacao == null ? other$numeroLicitacao != null : !((Object)this$numeroLicitacao).equals(other$numeroLicitacao)) {
            return false;
        }
        Optional this$tipoLicitacao = this.getTipoLicitacao();
        Optional other$tipoLicitacao = other.getTipoLicitacao();
        if (this$tipoLicitacao == null ? other$tipoLicitacao != null : !((Object)this$tipoLicitacao).equals(other$tipoLicitacao)) {
            return false;
        }
        Optional this$dataInicialAssinatura = this.getDataInicialAssinatura();
        Optional other$dataInicialAssinatura = other.getDataInicialAssinatura();
        if (this$dataInicialAssinatura == null ? other$dataInicialAssinatura != null : !((Object)this$dataInicialAssinatura).equals(other$dataInicialAssinatura)) {
            return false;
        }
        Optional this$dataFinalAssinatura = this.getDataFinalAssinatura();
        Optional other$dataFinalAssinatura = other.getDataFinalAssinatura();
        if (this$dataFinalAssinatura == null ? other$dataFinalAssinatura != null : !((Object)this$dataFinalAssinatura).equals(other$dataFinalAssinatura)) {
            return false;
        }
        Optional this$idContrato = this.getIdContrato();
        Optional other$idContrato = other.getIdContrato();
        if (this$idContrato == null ? other$idContrato != null : !((Object)this$idContrato).equals(other$idContrato)) {
            return false;
        }
        Optional this$rateio = this.getRateio();
        Optional other$rateio = other.getRateio();
        if (this$rateio == null ? other$rateio != null : !((Object)this$rateio).equals(other$rateio)) {
            return false;
        }
        Optional this$isCovid = this.getisCovid();
        Optional other$isCovid = other.getisCovid();
        if (this$isCovid == null ? other$isCovid != null : !((Object)this$isCovid).equals(other$isCovid)) {
            return false;
        }
        Optional this$tipoAto = this.getTipoAto();
        Optional other$tipoAto = other.getTipoAto();
        if (this$tipoAto == null ? other$tipoAto != null : !((Object)this$tipoAto).equals(other$tipoAto)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindContratoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Optional $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Optional $tipoContrato = this.getTipoContrato();
        result = result * 59 + ($tipoContrato == null ? 43 : ((Object)$tipoContrato).hashCode());
        Optional $contrato = this.getContrato();
        result = result * 59 + ($contrato == null ? 43 : ((Object)$contrato).hashCode());
        Optional $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : ((Object)$numeroContrato).hashCode());
        String $dataAtual = this.getDataAtual();
        result = result * 59 + ($dataAtual == null ? 43 : $dataAtual.hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Optional $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : ((Object)$nome).hashCode());
        Optional $exercicioContrato = this.getExercicioContrato();
        result = result * 59 + ($exercicioContrato == null ? 43 : ((Object)$exercicioContrato).hashCode());
        Optional $exercicioLicitacao = this.getExercicioLicitacao();
        result = result * 59 + ($exercicioLicitacao == null ? 43 : ((Object)$exercicioLicitacao).hashCode());
        Optional $numeroLicitacao = this.getNumeroLicitacao();
        result = result * 59 + ($numeroLicitacao == null ? 43 : ((Object)$numeroLicitacao).hashCode());
        Optional $tipoLicitacao = this.getTipoLicitacao();
        result = result * 59 + ($tipoLicitacao == null ? 43 : ((Object)$tipoLicitacao).hashCode());
        Optional $dataInicialAssinatura = this.getDataInicialAssinatura();
        result = result * 59 + ($dataInicialAssinatura == null ? 43 : ((Object)$dataInicialAssinatura).hashCode());
        Optional $dataFinalAssinatura = this.getDataFinalAssinatura();
        result = result * 59 + ($dataFinalAssinatura == null ? 43 : ((Object)$dataFinalAssinatura).hashCode());
        Optional $idContrato = this.getIdContrato();
        result = result * 59 + ($idContrato == null ? 43 : ((Object)$idContrato).hashCode());
        Optional $rateio = this.getRateio();
        result = result * 59 + ($rateio == null ? 43 : ((Object)$rateio).hashCode());
        Optional $isCovid = this.getisCovid();
        result = result * 59 + ($isCovid == null ? 43 : ((Object)$isCovid).hashCode());
        Optional $tipoAto = this.getTipoAto();
        result = result * 59 + ($tipoAto == null ? 43 : ((Object)$tipoAto).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }
}

