/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource;

import br.com.elotech.portaltransparencia.comprasportal.domain.AutorizacaoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AutorizacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAutorizacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.AutorizacaoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/autorizacoes"})
public class AutorizacaoResource {
    private final AutorizacaoService autorizacaoService;

    @Autowired
    public AutorizacaoResource(AutorizacaoService autorizacaoService) {
        this.autorizacaoService = autorizacaoService;
    }

    @GetMapping(params={"entidade", "exercicio", "tipoLicitacao", "licitacao"})
    public ResponseEntity<List<AutorizacaoLicitacaoDTO>> findAutorizacoes(FindLicitacaoParams params) {
        return ResponseEntity.ok((Object)this.autorizacaoService.findAutorizacoes(params));
    }

    @GetMapping(value={"/detalhes"}, params={"entidade", "exercicio", "numeroRequisicao"})
    public ResponseEntity<AutorizacaoLicitacaoDTO> findAutorizacao(FindAutorizacaoParams params) {
        return ResponseEntity.ok((Object)this.autorizacaoService.findAutorizacao(params));
    }

    @GetMapping(value={"/arquivos"}, params={"entidade", "exercicio", "numeroRequisicao"})
    public ResponseEntity<List<AutorizacaoArquivo>> findArquivos(FindAutorizacaoParams params) {
        return ResponseEntity.ok((Object)this.autorizacaoService.findArquivos(params));
    }
}

