/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service.impl;

import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.portaltransparencia.admportal.domain.PerguntaFrequente;
import br.com.elotech.portaltransparencia.admportal.domain.PerguntaFrequentePK;
import br.com.elotech.portaltransparencia.admportal.repository.PerguntaFrequenteRepository;
import br.com.elotech.portaltransparencia.admportal.service.PerguntaFrequenteService;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class PerguntaFrequenteServiceImpl
extends ReadOnlyService<PerguntaFrequente, PerguntaFrequentePK>
implements PerguntaFrequenteService {
    private final PerguntaFrequenteRepository perguntaFrequenteRepository;

    @Autowired
    public PerguntaFrequenteServiceImpl(PerguntaFrequenteRepository perguntaFrequenteRepository) {
        this.perguntaFrequenteRepository = perguntaFrequenteRepository;
    }

    public List<PerguntaFrequente> findByEntidadeAndFiltro(Long idEntidade, String filtro) {
        List perguntasByEntidade = this.perguntaFrequenteRepository.findByIdEntidadeIdAndAtivoTrue(idEntidade);
        if (StringUtils.isNotBlank((String)filtro)) {
            return perguntasByEntidade.stream().filter(p -> br.com.elotech.core.utils.StringUtils.simplify((String)p.getPergunta()).contains(br.com.elotech.core.utils.StringUtils.simplify((String)filtro)) || br.com.elotech.core.utils.StringUtils.simplify((String)p.getResposta()).contains(br.com.elotech.core.utils.StringUtils.simplify((String)filtro))).collect(Collectors.toList());
        }
        return perguntasByEntidade;
    }

    public Page<PerguntaFrequente> findByEntidade(Long idEntidade, Pageable page) {
        return this.perguntaFrequenteRepository.findByIdEntidadeId(idEntidade, page);
    }

    @Transactional
    public PerguntaFrequente save(PerguntaFrequente pergunta) {
        return (PerguntaFrequente)this.perguntaFrequenteRepository.save((Object)pergunta);
    }

    @Transactional
    public void remove(PerguntaFrequente pergunta) {
        this.perguntaFrequenteRepository.delete((Object)pergunta);
    }
}

