/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.resource;

import br.com.elotech.core.utils.StringUtils;
import br.com.elotech.portaltransparencia.protocportal.domain.Pessoa;
import br.com.elotech.portaltransparencia.protocportal.service.PessoaService;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pessoa"})
public class PessoaResource {
    private final PessoaService pessoaService;

    public PessoaResource(PessoaService pessoaService) {
        this.pessoaService = pessoaService;
    }

    @GetMapping(params={"cnpjCpf"})
    public ResponseEntity<Pessoa> findPessoaByCnpjCpf(String cnpjCpf) {
        Optional pessoa = this.pessoaService.findPessoaByCnpjCpf(StringUtils.somenteNumeros((String)cnpjCpf));
        return ResponseEntity.ok((Object)pessoa.orElseGet(Pessoa::new));
    }
}

