/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.folhaportal.service;

import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.QuadroPessoalDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.QuadroPessoalDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.contabportal.service.QuadroPessoalService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.unico.client.EntidadeFeignClient;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class QuadroPessoalServiceOxy
implements QuadroPessoalService {
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;
    private final EntidadeFeignClient entidadeClient;
    private final BaseExport baseExport;

    public Page<QuadroPessoalDTO> findQuadrosPessoal(CargoParams params, Pageable pageable) {
        List quadrosPessoal = this.findListQuadrosPessoal(params);
        return new PageImpl(quadrosPessoal, pageable, (long)quadrosPessoal.size());
    }

    public List<QuadroPessoalDTO> findListQuadrosPessoal(CargoParams params) {
        if (Objects.nonNull(params.getCompetencia())) {
            return this.integracaoFolhaPortalTransparenciaClient.findQuadroPessoalDTO(params.getEntidade(), params.getExercicio(), params.getCompetencia()).stream().map(QuadroPessoalDTOConverter::toQuadroPessoalDTO).collect(Collectors.toList());
        }
        return this.integracaoFolhaPortalTransparenciaClient.findQuadroPessoalDTO(params.getEntidade(), params.getExercicio()).stream().map(QuadroPessoalDTOConverter::toQuadroPessoalDTO).collect(Collectors.toList());
    }

    public String findNomeEntidadeById(Long entidadeId) {
        EntidadeDTO entidadeDTO = this.entidadeClient.findOne(entidadeId);
        return Objects.nonNull(entidadeDTO) ? entidadeDTO.getNome() : "";
    }

    @Generated
    public QuadroPessoalServiceOxy(IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient, EntidadeFeignClient entidadeClient, BaseExport baseExport) {
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
        this.entidadeClient = entidadeClient;
        this.baseExport = baseExport;
    }

    @Generated
    public BaseExport getBaseExport() {
        return this.baseExport;
    }
}

