/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.arquivoportal.repository.impl;

import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoCustomRepository;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class EloArquivoCustomRepositoryImpl
implements EloArquivoCustomRepository {
    private final DatasourceWrapper datasourceWrapper;
    private final String schemaEloArquivo;

    public EloArquivoCustomRepositoryImpl(DatasourceWrapper datasourceWrapper, @Value(value="${db.eloarquivo.schema:eloarquivo}") String schemaEloarquivo) {
        this.datasourceWrapper = datasourceWrapper;
        this.schemaEloArquivo = schemaEloarquivo;
    }

    public byte[] getPartBytes(Long id, Integer posIni, Integer posFim) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("posIni", (Object)posIni);
        params.addValue("posFim", (Object)posFim);
        params.addValue("id", (Object)id);
        String sql = String.format("select substring(arquivo, :posIni, :posFim) from %s.arquivo_content where id = :id", this.schemaEloArquivo);
        return (byte[])this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, byte[].class);
    }
}

