/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.mapper;

import br.com.elotech.portaltransparencia.contabportal.domain.ItemEmpenho;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ComprasDiretaDTO;
import java.util.Objects;
import java.util.function.Function;

public class ComprasDiretaToDTO
implements Function<ItemEmpenho, ComprasDiretaDTO> {
    @Override
    public ComprasDiretaDTO apply(ItemEmpenho item) {
        ComprasDiretaDTO dto = new ComprasDiretaDTO();
        dto.setEntidade(item.getId().getEmpenho().getId().getEntidade());
        dto.setExercicio(item.getId().getEmpenho().getId().getExercicio());
        dto.setEmpenho(item.getId().getEmpenho().getId().getEmpenho());
        dto.setUnidadeOrcamentaria(item.getId().getEmpenho().getId().getUnidadeOrcamentaria());
        dto.setData(item.getId().getEmpenho().getData());
        dto.setNumeroProcesso(item.getId().getEmpenho().getNumeroProcesso());
        dto.setOrdem(item.getId().getOrdem());
        dto.setItem(item.getEspecificacao());
        dto.setQuantidade(item.getQuantidade());
        dto.setValorTotal(item.getValorTotal());
        dto.setValorUnitario(item.getValorUnitario());
        dto.setUnidadeItem(item.getUnidadeItem());
        if (Objects.nonNull(item.getId().getEmpenho().getTipoLicitacao())) {
            dto.setTipoLicitacao(item.getId().getEmpenho().getTipoLicitacao().getId());
        }
        if (Objects.nonNull(item.getId().getEmpenho().getFornecedor())) {
            dto.setFornecedor(item.getId().getEmpenho().getFornecedor().getNome());
            dto.setCnpj(item.getId().getEmpenho().getFornecedor().getCnpj());
        }
        return dto;
    }
}

