/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.domain.dto.PortalConfigDTO;
import br.com.elotech.portaltransparencia.admportal.service.ActiveProfile;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.admportal.utils.SecurityUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/admin/config"})
@RestController
public class PortalConfigResource {
    private final Environment environment;
    private final PortalParametroService parametroService;

    public PortalConfigResource(Environment environment, PortalParametroService parametroService) {
        this.environment = environment;
        this.parametroService = parametroService;
    }

    @GetMapping
    public ResponseEntity<PortalConfigDTO> getPortalConfig() {
        PortalConfigDTO config = new PortalConfigDTO();
        Boolean isKeyCloak = ActiveProfile.isProfileActive((Environment)this.environment, (String)"keycloak");
        config.setIsIntegradoKeyCloak(isKeyCloak);
        return ResponseEntity.ok((Object)config);
    }

    @GetMapping(value={"/possui-acesso"})
    public ResponseEntity<Boolean> possuiAcessoAdministrador() {
        String portalParametroValor = this.parametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ADMINS_SISTEMA);
        List administradores = Arrays.stream(Optional.ofNullable(portalParametroValor).orElse("").split(";")).collect(Collectors.toList());
        return ResponseEntity.ok((Object)administradores.contains(SecurityUtils.getEmail()));
    }
}

