SELECT EX.MES, 
   (SELECT COALESCE(SUM(RD.VALORARRECADADO-RD.VALORESTARRECADADO-RD.VALORDEVOLUCAO+RD.VALORESTDEVOLUCAO),0) 
           FROM ${db.contabilidade.schema}.RECEITADIARIA RD
           LEFT OUTER JOIN ${db.contabilidade.schema}.RECEITA R
             ON RD.ENTIDADE = R.ENTIDADE 
            AND RD.EXERCICIO = R.EXERCICIO 
            AND RD.RECEITA = R.RECEITA 
            AND RD.FONTERECURSO = R.FONTERECURSO 
            AND RD.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA
			AND R.COVID19 = 'S'
           WHERE EX.MES = EXTRACT(MONTH FROM RD.DATA) 
             AND RD.DATA <= :diasRetroativo
             AND R.MOVSN = 'S') AS VALORARRECADADO,
	(SELECT COALESCE(SUM(FICHA.VALOR - FICHA.VALORANULACOES + FICHA.VALORESTANULACOES),0)
       FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA, ${db.contabilidade.schema}.EMPENHO E
	  WHERE E.ENTIDADE = FICHA.ENTIDADE
		AND E.EXERCICIO = FICHA.EXERCICIO
		AND E.EMPENHO = FICHA.EMPENHO
		AND E.UNIDADEORCAMENTARIA = FICHA.UNIDADEORCAMENTARIA
        AND E.MPCOVID19 = 'S'
		AND FICHA.DATA <= :diasRetroativo
        AND EXTRACT(MONTH FROM FICHA.DATA) = EX.MES) AS VALOREMPENHADO,  
    (SELECT COALESCE(SUM(FICHA.VALORLIQUIDACOES - FICHA.VALORESTLIQUIDACOES),0)
       FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA, ${db.contabilidade.schema}.EMPENHO E
	  WHERE E.ENTIDADE = FICHA.ENTIDADE
		AND E.EXERCICIO = FICHA.EXERCICIO
		AND E.EMPENHO = FICHA.EMPENHO
		AND E.UNIDADEORCAMENTARIA = FICHA.UNIDADEORCAMENTARIA
        AND E.MPCOVID19 = 'S'
		AND FICHA.DATA <= :diasRetroativo
        AND EXTRACT(MONTH FROM FICHA.DATA) = EX.MES) AS VALORLIQUIDADO,
	(SELECT COALESCE(SUM(FICHA.VALORPAGAMENTO - FICHA.VALORESTPAGAMENTO),0)
       FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA, ${db.contabilidade.schema}.EMPENHO E
	  WHERE E.ENTIDADE = FICHA.ENTIDADE
		AND E.EXERCICIO = FICHA.EXERCICIO
		AND E.EMPENHO = FICHA.EMPENHO
		AND E.UNIDADEORCAMENTARIA = FICHA.UNIDADEORCAMENTARIA
        AND E.MPCOVID19 = 'S'
		AND FICHA.DATA <= :diasRetroativo
        AND EXTRACT(MONTH FROM FICHA.DATA) = EX.MES) AS VALORPAGO
 FROM ${db.contabilidade.schema}.EXERCICIO_MES EX
 GROUP BY EX.MES
 ORDER BY EX.MES