SELECT LIC.ENTIDADE AS ENTIDADE,
       LIC.EXERCICIO AS EXERCICIO,
       LIC.TIPOLICITACAO AS TIPOLICITACAO,
       LIC.LICITACAO AS LICITACAO,
       REQNAD.NUMEROREQUISICAO AS NUMEROREQUISICAO,
       REQNAD.EXERCICIO AS EXERCICIOREQUISICAO,
       REQNAD.DATA AS DATANAD,
       PES.NOME AS NOMEFORNECEDOR,
       NAD.NUMERONAD AS NUMERONAD,
       NAD.EXERCICIO AS EXERCICIONAD,
       NAD.EMPENHO AS EMPENHO,
       REQNAD.VALOR AS VALORREQUISICAO
  FROM ${db.compras.schema}.CLREQUISICAONAD REQNAD
  JOIN ${db.compras.schema}.CLNAD NAD
    ON NAD.NAD       = REQNAD.NAD
   AND NAD.EXERCICIO = REQNAD.EXERCICIONAD
   AND NAD.ENTIDADE  = REQNAD.ENTIDADE
   AND NAD.PESSOA    = REQNAD.PESSOA
  LEFT JOIN ${db.compras.schema}.CLLICITACAO LIC
    ON LIC.ENTIDADE      = NAD.ENTIDADELICITACAO
   AND LIC.EXERCICIO     = NAD.EXERCICIOLICITACAO
   AND LIC.TIPOLICITACAO = NAD.TIPOLICITACAO
   AND LIC.LICITACAO     = NAD.LICITACAO
  JOIN ${db.compras.schema}.PESSOA PES
    ON PES.PESSOA = REQNAD.PESSOA
 WHERE LIC.ENTIDADE      = :entidade
   AND LIC.EXERCICIO     = :exercicio
   AND LIC.TIPOLICITACAO = :tipoLicitacao
   AND LIC.LICITACAO     = :licitacao
 ORDER BY REQNAD.DATA