/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.web.rest.params;

import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class ServidorParams
implements AiseParams {
    private String nomeServidor;
    private Long entidade;
    private Long entidadeAise;
    private Long exercicio;
    private Long matricula;
    private Long anoCompetencia;
    private Long mesCompetencia;
    private String tipoEvento;
    private Long tipoFolha;
    private String situacao;
    private String cargo;
    private Long natureza;
    private Long codigoCalculo;
    private String exibePonto;
    private String exportType;
    private String lotacao;
    private String classe;
    private BigDecimal valorSalarioInicial;
    private BigDecimal valorSalarioFinal;
    private boolean aposentados;
    private String descricaoNatureza;
    private String vinculo;
    private Long codigo;
    private String cpf;
    private Boolean estagioVigente;
    private Boolean admissaoExcepcional;
    private Long entidadeOrigem;

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidadeAise(params);
        this.addExercicio(params);
        this.addMatricula(params);
        this.addData(params);
        this.addCompetencia(params);
        this.addTipoEvento(params);
        this.addTipoFolha(params);
        this.addCodigo(params);
        this.addEntidadeOrigem(params);
        return params;
    }

    private void addTipoFolha(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoFolha)) {
            params.addValue("tipoFolha", (Object)this.tipoFolha);
        }
    }

    private void addTipoEvento(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoEvento)) {
            params.addValue("tipoEvento", (Object)this.tipoEvento);
        }
    }

    private void addCompetencia(MapSqlParameterSource params) {
        if (Objects.nonNull(this.anoCompetencia)) {
            params.addValue("anoCompetencia", (Object)this.anoCompetencia);
        }
        if (Objects.nonNull(this.mesCompetencia)) {
            params.addValue("mesCompetencia", (Object)this.mesCompetencia);
        }
    }

    private void addData(MapSqlParameterSource params) {
        LocalDate data = LocalDate.now();
        if (!this.anoAtual(this.anoCompetencia)) {
            data = data.withYear(this.anoCompetencia.intValue()).with(TemporalAdjusters.lastDayOfYear());
        }
        params.addValue("dataAtual", (Object)data.toString(), 91);
    }

    private void addMatricula(MapSqlParameterSource params) {
        if (Objects.nonNull(this.matricula)) {
            params.addValue("matricula", (Object)this.matricula, 2);
        }
    }

    private void addCodigo(MapSqlParameterSource params) {
        if (Objects.nonNull(this.codigo)) {
            params.addValue("codigo", (Object)this.codigo, 2);
        }
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addEntidadeAise(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidadeAise)) {
            params.addValue("entidade", (Object)this.entidadeAise, 2);
        }
    }

    public boolean anoAtual(Long exercicio) {
        return Long.valueOf(LocalDate.now().getYear()).equals(exercicio) || Objects.isNull(exercicio);
    }

    private void addEntidadeOrigem(MapSqlParameterSource params) {
        if (NumberUtils.isBiggerThanZero((Number)this.entidadeOrigem).booleanValue()) {
            params.addValue("entidade", (Object)this.entidadeOrigem, 2);
        }
    }

    @Generated
    public static ServidorParamsBuilder builder() {
        return new ServidorParamsBuilder();
    }

    @Generated
    public String toString() {
        return "ServidorParams(nomeServidor=" + this.getNomeServidor() + ", entidade=" + this.getEntidade() + ", entidadeAise=" + this.getEntidadeAise() + ", exercicio=" + this.getExercicio() + ", matricula=" + this.getMatricula() + ", anoCompetencia=" + this.getAnoCompetencia() + ", mesCompetencia=" + this.getMesCompetencia() + ", tipoEvento=" + this.getTipoEvento() + ", tipoFolha=" + this.getTipoFolha() + ", situacao=" + this.getSituacao() + ", cargo=" + this.getCargo() + ", natureza=" + this.getNatureza() + ", codigoCalculo=" + this.getCodigoCalculo() + ", exibePonto=" + this.getExibePonto() + ", exportType=" + this.getExportType() + ", lotacao=" + this.getLotacao() + ", classe=" + this.getClasse() + ", valorSalarioInicial=" + this.getValorSalarioInicial() + ", valorSalarioFinal=" + this.getValorSalarioFinal() + ", aposentados=" + this.isAposentados() + ", descricaoNatureza=" + this.getDescricaoNatureza() + ", vinculo=" + this.getVinculo() + ", codigo=" + this.getCodigo() + ", cpf=" + this.getCpf() + ", estagioVigente=" + this.getEstagioVigente() + ", admissaoExcepcional=" + this.getAdmissaoExcepcional() + ", entidadeOrigem=" + this.getEntidadeOrigem() + ")";
    }

    @Generated
    public ServidorParams() {
    }

    @Generated
    public ServidorParams(String nomeServidor, Long entidade, Long entidadeAise, Long exercicio, Long matricula, Long anoCompetencia, Long mesCompetencia, String tipoEvento, Long tipoFolha, String situacao, String cargo, Long natureza, Long codigoCalculo, String exibePonto, String exportType, String lotacao, String classe, BigDecimal valorSalarioInicial, BigDecimal valorSalarioFinal, boolean aposentados, String descricaoNatureza, String vinculo, Long codigo, String cpf, Boolean estagioVigente, Boolean admissaoExcepcional, Long entidadeOrigem) {
        this.nomeServidor = nomeServidor;
        this.entidade = entidade;
        this.entidadeAise = entidadeAise;
        this.exercicio = exercicio;
        this.matricula = matricula;
        this.anoCompetencia = anoCompetencia;
        this.mesCompetencia = mesCompetencia;
        this.tipoEvento = tipoEvento;
        this.tipoFolha = tipoFolha;
        this.situacao = situacao;
        this.cargo = cargo;
        this.natureza = natureza;
        this.codigoCalculo = codigoCalculo;
        this.exibePonto = exibePonto;
        this.exportType = exportType;
        this.lotacao = lotacao;
        this.classe = classe;
        this.valorSalarioInicial = valorSalarioInicial;
        this.valorSalarioFinal = valorSalarioFinal;
        this.aposentados = aposentados;
        this.descricaoNatureza = descricaoNatureza;
        this.vinculo = vinculo;
        this.codigo = codigo;
        this.cpf = cpf;
        this.estagioVigente = estagioVigente;
        this.admissaoExcepcional = admissaoExcepcional;
        this.entidadeOrigem = entidadeOrigem;
    }

    @Generated
    public String getNomeServidor() {
        return this.nomeServidor;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getEntidadeAise() {
        return this.entidadeAise;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getMatricula() {
        return this.matricula;
    }

    @Generated
    public Long getAnoCompetencia() {
        return this.anoCompetencia;
    }

    @Generated
    public Long getMesCompetencia() {
        return this.mesCompetencia;
    }

    @Generated
    public String getTipoEvento() {
        return this.tipoEvento;
    }

    @Generated
    public Long getTipoFolha() {
        return this.tipoFolha;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getCargo() {
        return this.cargo;
    }

    @Generated
    public Long getNatureza() {
        return this.natureza;
    }

    @Generated
    public Long getCodigoCalculo() {
        return this.codigoCalculo;
    }

    @Generated
    public String getExibePonto() {
        return this.exibePonto;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public String getLotacao() {
        return this.lotacao;
    }

    @Generated
    public String getClasse() {
        return this.classe;
    }

    @Generated
    public BigDecimal getValorSalarioInicial() {
        return this.valorSalarioInicial;
    }

    @Generated
    public BigDecimal getValorSalarioFinal() {
        return this.valorSalarioFinal;
    }

    @Generated
    public boolean isAposentados() {
        return this.aposentados;
    }

    @Generated
    public String getDescricaoNatureza() {
        return this.descricaoNatureza;
    }

    @Generated
    public String getVinculo() {
        return this.vinculo;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public String getCpf() {
        return this.cpf;
    }

    @Generated
    public Boolean getEstagioVigente() {
        return this.estagioVigente;
    }

    @Generated
    public Boolean getAdmissaoExcepcional() {
        return this.admissaoExcepcional;
    }

    @Generated
    public Long getEntidadeOrigem() {
        return this.entidadeOrigem;
    }

    @Generated
    public void setNomeServidor(String nomeServidor) {
        this.nomeServidor = nomeServidor;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setEntidadeAise(Long entidadeAise) {
        this.entidadeAise = entidadeAise;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setMatricula(Long matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setAnoCompetencia(Long anoCompetencia) {
        this.anoCompetencia = anoCompetencia;
    }

    @Generated
    public void setMesCompetencia(Long mesCompetencia) {
        this.mesCompetencia = mesCompetencia;
    }

    @Generated
    public void setTipoEvento(String tipoEvento) {
        this.tipoEvento = tipoEvento;
    }

    @Generated
    public void setTipoFolha(Long tipoFolha) {
        this.tipoFolha = tipoFolha;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    @Generated
    public void setNatureza(Long natureza) {
        this.natureza = natureza;
    }

    @Generated
    public void setCodigoCalculo(Long codigoCalculo) {
        this.codigoCalculo = codigoCalculo;
    }

    @Generated
    public void setExibePonto(String exibePonto) {
        this.exibePonto = exibePonto;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public void setLotacao(String lotacao) {
        this.lotacao = lotacao;
    }

    @Generated
    public void setClasse(String classe) {
        this.classe = classe;
    }

    @Generated
    public void setValorSalarioInicial(BigDecimal valorSalarioInicial) {
        this.valorSalarioInicial = valorSalarioInicial;
    }

    @Generated
    public void setValorSalarioFinal(BigDecimal valorSalarioFinal) {
        this.valorSalarioFinal = valorSalarioFinal;
    }

    @Generated
    public void setAposentados(boolean aposentados) {
        this.aposentados = aposentados;
    }

    @Generated
    public void setDescricaoNatureza(String descricaoNatureza) {
        this.descricaoNatureza = descricaoNatureza;
    }

    @Generated
    public void setVinculo(String vinculo) {
        this.vinculo = vinculo;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    @Generated
    public void setEstagioVigente(Boolean estagioVigente) {
        this.estagioVigente = estagioVigente;
    }

    @Generated
    public void setAdmissaoExcepcional(Boolean admissaoExcepcional) {
        this.admissaoExcepcional = admissaoExcepcional;
    }

    @Generated
    public void setEntidadeOrigem(Long entidadeOrigem) {
        this.entidadeOrigem = entidadeOrigem;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServidorParams)) {
            return false;
        }
        ServidorParams other = (ServidorParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$nomeServidor = this.getNomeServidor();
        String other$nomeServidor = other.getNomeServidor();
        if (this$nomeServidor == null ? other$nomeServidor != null : !this$nomeServidor.equals(other$nomeServidor)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$entidadeAise = this.getEntidadeAise();
        Long other$entidadeAise = other.getEntidadeAise();
        if (this$entidadeAise == null ? other$entidadeAise != null : !((Object)this$entidadeAise).equals(other$entidadeAise)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$matricula = this.getMatricula();
        Long other$matricula = other.getMatricula();
        if (this$matricula == null ? other$matricula != null : !((Object)this$matricula).equals(other$matricula)) {
            return false;
        }
        Long this$anoCompetencia = this.getAnoCompetencia();
        Long other$anoCompetencia = other.getAnoCompetencia();
        if (this$anoCompetencia == null ? other$anoCompetencia != null : !((Object)this$anoCompetencia).equals(other$anoCompetencia)) {
            return false;
        }
        Long this$mesCompetencia = this.getMesCompetencia();
        Long other$mesCompetencia = other.getMesCompetencia();
        if (this$mesCompetencia == null ? other$mesCompetencia != null : !((Object)this$mesCompetencia).equals(other$mesCompetencia)) {
            return false;
        }
        String this$tipoEvento = this.getTipoEvento();
        String other$tipoEvento = other.getTipoEvento();
        if (this$tipoEvento == null ? other$tipoEvento != null : !this$tipoEvento.equals(other$tipoEvento)) {
            return false;
        }
        Long this$tipoFolha = this.getTipoFolha();
        Long other$tipoFolha = other.getTipoFolha();
        if (this$tipoFolha == null ? other$tipoFolha != null : !((Object)this$tipoFolha).equals(other$tipoFolha)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        String this$cargo = this.getCargo();
        String other$cargo = other.getCargo();
        if (this$cargo == null ? other$cargo != null : !this$cargo.equals(other$cargo)) {
            return false;
        }
        Long this$natureza = this.getNatureza();
        Long other$natureza = other.getNatureza();
        if (this$natureza == null ? other$natureza != null : !((Object)this$natureza).equals(other$natureza)) {
            return false;
        }
        Long this$codigoCalculo = this.getCodigoCalculo();
        Long other$codigoCalculo = other.getCodigoCalculo();
        if (this$codigoCalculo == null ? other$codigoCalculo != null : !((Object)this$codigoCalculo).equals(other$codigoCalculo)) {
            return false;
        }
        String this$exibePonto = this.getExibePonto();
        String other$exibePonto = other.getExibePonto();
        if (this$exibePonto == null ? other$exibePonto != null : !this$exibePonto.equals(other$exibePonto)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        if (this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType)) {
            return false;
        }
        String this$lotacao = this.getLotacao();
        String other$lotacao = other.getLotacao();
        if (this$lotacao == null ? other$lotacao != null : !this$lotacao.equals(other$lotacao)) {
            return false;
        }
        String this$classe = this.getClasse();
        String other$classe = other.getClasse();
        if (this$classe == null ? other$classe != null : !this$classe.equals(other$classe)) {
            return false;
        }
        BigDecimal this$valorSalarioInicial = this.getValorSalarioInicial();
        BigDecimal other$valorSalarioInicial = other.getValorSalarioInicial();
        if (this$valorSalarioInicial == null ? other$valorSalarioInicial != null : !((Object)this$valorSalarioInicial).equals(other$valorSalarioInicial)) {
            return false;
        }
        BigDecimal this$valorSalarioFinal = this.getValorSalarioFinal();
        BigDecimal other$valorSalarioFinal = other.getValorSalarioFinal();
        if (this$valorSalarioFinal == null ? other$valorSalarioFinal != null : !((Object)this$valorSalarioFinal).equals(other$valorSalarioFinal)) {
            return false;
        }
        if (this.isAposentados() != other.isAposentados()) {
            return false;
        }
        String this$descricaoNatureza = this.getDescricaoNatureza();
        String other$descricaoNatureza = other.getDescricaoNatureza();
        if (this$descricaoNatureza == null ? other$descricaoNatureza != null : !this$descricaoNatureza.equals(other$descricaoNatureza)) {
            return false;
        }
        String this$vinculo = this.getVinculo();
        String other$vinculo = other.getVinculo();
        if (this$vinculo == null ? other$vinculo != null : !this$vinculo.equals(other$vinculo)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        String this$cpf = this.getCpf();
        String other$cpf = other.getCpf();
        if (this$cpf == null ? other$cpf != null : !this$cpf.equals(other$cpf)) {
            return false;
        }
        Boolean this$estagioVigente = this.getEstagioVigente();
        Boolean other$estagioVigente = other.getEstagioVigente();
        if (this$estagioVigente == null ? other$estagioVigente != null : !((Object)this$estagioVigente).equals(other$estagioVigente)) {
            return false;
        }
        Boolean this$admissaoExcepcional = this.getAdmissaoExcepcional();
        Boolean other$admissaoExcepcional = other.getAdmissaoExcepcional();
        if (this$admissaoExcepcional == null ? other$admissaoExcepcional != null : !((Object)this$admissaoExcepcional).equals(other$admissaoExcepcional)) {
            return false;
        }
        Long this$entidadeOrigem = this.getEntidadeOrigem();
        Long other$entidadeOrigem = other.getEntidadeOrigem();
        return !(this$entidadeOrigem == null ? other$entidadeOrigem != null : !((Object)this$entidadeOrigem).equals(other$entidadeOrigem));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServidorParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nomeServidor = this.getNomeServidor();
        result = result * 59 + ($nomeServidor == null ? 43 : $nomeServidor.hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $entidadeAise = this.getEntidadeAise();
        result = result * 59 + ($entidadeAise == null ? 43 : ((Object)$entidadeAise).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $matricula = this.getMatricula();
        result = result * 59 + ($matricula == null ? 43 : ((Object)$matricula).hashCode());
        Long $anoCompetencia = this.getAnoCompetencia();
        result = result * 59 + ($anoCompetencia == null ? 43 : ((Object)$anoCompetencia).hashCode());
        Long $mesCompetencia = this.getMesCompetencia();
        result = result * 59 + ($mesCompetencia == null ? 43 : ((Object)$mesCompetencia).hashCode());
        String $tipoEvento = this.getTipoEvento();
        result = result * 59 + ($tipoEvento == null ? 43 : $tipoEvento.hashCode());
        Long $tipoFolha = this.getTipoFolha();
        result = result * 59 + ($tipoFolha == null ? 43 : ((Object)$tipoFolha).hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        String $cargo = this.getCargo();
        result = result * 59 + ($cargo == null ? 43 : $cargo.hashCode());
        Long $natureza = this.getNatureza();
        result = result * 59 + ($natureza == null ? 43 : ((Object)$natureza).hashCode());
        Long $codigoCalculo = this.getCodigoCalculo();
        result = result * 59 + ($codigoCalculo == null ? 43 : ((Object)$codigoCalculo).hashCode());
        String $exibePonto = this.getExibePonto();
        result = result * 59 + ($exibePonto == null ? 43 : $exibePonto.hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        String $lotacao = this.getLotacao();
        result = result * 59 + ($lotacao == null ? 43 : $lotacao.hashCode());
        String $classe = this.getClasse();
        result = result * 59 + ($classe == null ? 43 : $classe.hashCode());
        BigDecimal $valorSalarioInicial = this.getValorSalarioInicial();
        result = result * 59 + ($valorSalarioInicial == null ? 43 : ((Object)$valorSalarioInicial).hashCode());
        BigDecimal $valorSalarioFinal = this.getValorSalarioFinal();
        result = result * 59 + ($valorSalarioFinal == null ? 43 : ((Object)$valorSalarioFinal).hashCode());
        result = result * 59 + (this.isAposentados() ? 79 : 97);
        String $descricaoNatureza = this.getDescricaoNatureza();
        result = result * 59 + ($descricaoNatureza == null ? 43 : $descricaoNatureza.hashCode());
        String $vinculo = this.getVinculo();
        result = result * 59 + ($vinculo == null ? 43 : $vinculo.hashCode());
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        String $cpf = this.getCpf();
        result = result * 59 + ($cpf == null ? 43 : $cpf.hashCode());
        Boolean $estagioVigente = this.getEstagioVigente();
        result = result * 59 + ($estagioVigente == null ? 43 : ((Object)$estagioVigente).hashCode());
        Boolean $admissaoExcepcional = this.getAdmissaoExcepcional();
        result = result * 59 + ($admissaoExcepcional == null ? 43 : ((Object)$admissaoExcepcional).hashCode());
        Long $entidadeOrigem = this.getEntidadeOrigem();
        result = result * 59 + ($entidadeOrigem == null ? 43 : ((Object)$entidadeOrigem).hashCode());
        return result;
    }
}

