/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.HomologacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.HomologacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindHomologacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class HomologacaoRepositoryImpl
implements HomologacaoRepository {
    private static final String HOMOLOGACAO = "db/sql/compras/homologacao.sql";
    private static final String HOMOLOGACOES = "db/sql/compras/homologacoes.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public HomologacaoRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public HomologacaoLicitacaoDTO findHomologacao(FindHomologacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)HOMOLOGACAO);
        return (HomologacaoLicitacaoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(HomologacaoLicitacaoDTO.class));
    }

    public List<HomologacaoLicitacaoDTO> findHomologacoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)HOMOLOGACOES).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(HomologacaoLicitacaoDTO.class));
    }
}

