/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.security;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Filter;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.springsecurity.KeycloakSecurityComponents;
import org.keycloak.adapters.springsecurity.authentication.KeycloakAuthenticationProvider;
import org.keycloak.adapters.springsecurity.config.KeycloakWebSecurityConfigurerAdapter;
import org.keycloak.adapters.springsecurity.filter.KeycloakAuthenticationProcessingFilter;
import org.keycloak.adapters.springsecurity.filter.KeycloakPreAuthActionsFilter;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAuthorityMapper;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;

@Configuration
@EnableWebSecurity
@Profile(value={"keycloak"})
@ComponentScan(basePackageClasses={KeycloakSecurityComponents.class})
public class KeycloakConfigurer
extends KeycloakWebSecurityConfigurerAdapter {
    protected SessionAuthenticationStrategy sessionAuthenticationStrategy() {
        return new NullAuthenticatedSessionStrategy();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        KeycloakAuthenticationProvider keycloakAuthenticationProvider = this.keycloakAuthenticationProvider();
        keycloakAuthenticationProvider.setGrantedAuthoritiesMapper((GrantedAuthoritiesMapper)new SimpleAuthorityMapper());
        auth.authenticationProvider((AuthenticationProvider)keycloakAuthenticationProvider);
    }

    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).sessionAuthenticationStrategy(this.sessionAuthenticationStrategy()).and()).authorizeRequests().antMatchers(new String[]{"/health/**"})).permitAll().antMatchers(new String[]{"/admin/actuator/info"})).permitAll().antMatchers(new String[]{"/admin/**"})).authenticated().antMatchers(new String[]{"/api/**"})).permitAll();
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/admin/config"})).antMatchers(new String[]{"/admin/actuator/**"})).antMatchers(new String[]{"/api/**"});
    }

    @Bean
    public FilterRegistrationBean<KeycloakAuthenticationProcessingFilter> keycloakAuthenticationProcessingFilterRegistrationBean(KeycloakAuthenticationProcessingFilter filter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setEnabled(false);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<KeycloakPreAuthActionsFilter> keycloakPreAuthActionsFilterRegistrationBean(KeycloakPreAuthActionsFilter filter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setEnabled(false);
        return registrationBean;
    }

    @Bean
    public KeycloakDeployment keycloakDeployment(@Value(value="${keycloak.configurationFile}") Resource keycloakConfigurationFile) throws IOException {
        return KeycloakDeploymentBuilder.build((InputStream)keycloakConfigurationFile.getInputStream());
    }

    @Bean
    public RealmResource keycloakRealmClient(Keycloak keycloakClient, KeycloakDeployment keycloakDeployment) throws IOException {
        return keycloakClient.realm(keycloakDeployment.getRealm());
    }

    @Bean
    public Keycloak keycloakAdminClient(@Value(value="${keycloak.configurationFile}") Resource keycloakConfigurationFile) throws IOException {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)keycloakConfigurationFile.getInputStream());
        return KeycloakBuilder.builder().clientId(deployment.getResourceName()).clientSecret(deployment.getResourceCredentials().get("secret").toString()).realm(deployment.getRealm()).grantType("client_credentials").serverUrl(deployment.getAuthServerBaseUrl()).build();
    }
}

