/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DiariaPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.TipoObjetivoDiariaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.TipoSecretariaDiariaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.DiariaRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.service.DiariaService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class DiariaSustantacaoService
implements DiariaService {
    private final DiariaRepository diariaRepository;
    private final ArquivoService arquivoService;

    @Autowired
    public DiariaSustantacaoService(DiariaRepository diariaRepository, ArquivoService arquivoService) {
        this.diariaRepository = diariaRepository;
        this.arquivoService = arquivoService;
    }

    public List<DiariaPessoalDTO> findDiariasWithoutQuantidade(FindPessoalParams params) {
        return this.diariaRepository.findDiariasWithoutQuantidade(params);
    }

    public Page<DiariaPessoalDTO> findDiarias(FindPessoalParams params, Pageable pageable) {
        return this.diariaRepository.findDiarias(params, pageable);
    }

    public DiariaPessoalDTO findTotalDiarias(FindPessoalParams params) {
        return this.diariaRepository.findTotalDiarias(params);
    }

    public Optional<DiariaPessoalDTO> findDiaria(FindPessoalParams params) {
        return this.diariaRepository.findDiaria(params);
    }

    public List<ArquivoPessoalDTO> findArquivos(FindPessoalParams params) {
        return this.diariaRepository.findArquivos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<TipoObjetivoDiariaDTO> getTiposObjetivoDiaria() {
        return this.diariaRepository.getTiposObjetivoDiaria();
    }

    public List<TipoSecretariaDiariaDTO> getTiposSecretariaDiaria(FindPessoalParams params) {
        return this.diariaRepository.getTiposSecretariaDiaria(params);
    }
}

