/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DespesaDetalhadaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DespesaPorNivelDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.DespesaPorNivelRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.DespesaParams;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;

public class DespesaPorNivelSustentacaoRepository
implements DespesaPorNivelRepository {
    private static final String DESPESA_POR_NIVEL = "db/sql/contab/despesaPorNivel.sql";
    private static final String DESPESA_DETALHADA = "db/sql/contab/despesa-detalhada.sql";
    private static final String DESPESA_AGRUPADA_NIVEL = "db/sql/contab/despesa-por-nivel.sql";
    private static final String DESPESA_AGRUPADA_NIVEL_SUB = "db/sql/contab/despesa-por-nivel-subselect.sql";
    private static final String DESPESA_POR_FONTE_RECURSO = "db/sql/contab/despesaPorFonteRecurso.sql";
    private static final String DESPESA_POR_ESFERA_ADMINISTRACAO = "db/sql/contab/despesaPorEsferaAdministrativa.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public DespesaPorNivelSustentacaoRepository(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<DespesaPorNivelDTO> getDespesaPorNivel(Long entidade, Long exercicio, String nivelLei, String tipo) {
        String sql = FileUtils.readResourceAsString((String)DESPESA_POR_NIVEL);
        return this.datasourceWrapper.getSimpleJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(DespesaPorNivelDTO.class), new Object[]{entidade, exercicio, nivelLei, tipo});
    }

    public List<DespesaPorNivelDTO> getDespesaPorFonteRecurso(Long entidade, Long exercicio) {
        String sql = FileUtils.readResourceAsString((String)DESPESA_POR_FONTE_RECURSO);
        return this.datasourceWrapper.getSimpleJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(DespesaPorNivelDTO.class), new Object[]{entidade, exercicio});
    }

    public List<DespesaPorNivelDTO> getDespesaPorEsferaAdministrativa(Long entidade, Long exercicio) {
        String sql = FileUtils.readResourceAsString((String)DESPESA_POR_ESFERA_ADMINISTRACAO);
        return this.datasourceWrapper.getSimpleJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(DespesaPorNivelDTO.class), new Object[]{entidade, exercicio});
    }

    public List<DespesaDetalhadaDTO> getDepesaDetalhada(Long entidade, Long exercicio) {
        String sql = FileUtils.readResourceAsString((String)DESPESA_DETALHADA);
        return this.datasourceWrapper.getSimpleJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(DespesaDetalhadaDTO.class), new Object[]{entidade, exercicio, entidade, exercicio});
    }

    public List<DespesaDetalhadaDTO> getDepesaAgrupaNivel(DespesaParams params) {
        Long projeto = 6L;
        String sql = FileUtils.readResourceAsString((String)DESPESA_AGRUPADA_NIVEL);
        String subSql = FileUtils.readResourceAsString((String)DESPESA_AGRUPADA_NIVEL_SUB).replace("$[CODIGO]", params.getNivelPrograma().toString());
        sql = sql.replace("$[SUBSTR]", this.montaSubString(params));
        if (params.getNivel().equals(projeto)) {
            sql = sql.replace("$[SUBSELECT]", subSql);
        }
        sql = sql.replace("$[SUBSELECT]", "");
        return this.datasourceWrapper.getSimpleJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(DespesaDetalhadaDTO.class), new Object[]{params.getEntidade(), params.getExercicio(), params.getEntidade(), params.getExercicio(), params.getNivel()});
    }

    public String montaSubString(DespesaParams params) {
        Long natureza = 10L;
        if (params.getNivel().equals(natureza)) {
            return "SUBSTR(D.PROGRAMATICA,19, 6)";
        }
        Long unidade = 2L;
        if (params.getNivel().equals(unidade)) {
            return "SUBSTR(D.PROGRAMATICA,1, 5)";
        }
        return "SUBSTR(D.PROGRAMATICA,D.INICIO, D.TAMANHO)";
    }
}

