/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.AnulacaoEmpenhoDTO;
import br.com.elotech.contabilidade.client.dto.ExercicioDTO;
import br.com.elotech.core.utils.NumberUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

public class EmpenhoAnulacaoDTO {
    private Long entidade;
    private Long empenho;
    private Long exercicio;
    private String unidadeOrcamentaria;
    private Long sequencia;
    private LocalDate data;
    private String motivo;
    private BigDecimal valor;

    public EmpenhoAnulacaoDTO(AnulacaoEmpenhoDTO anulacaoEmpenho) {
        ExercicioDTO exercicioAnulacao = anulacaoEmpenho.getExercicio();
        this.entidade = exercicioAnulacao.getEntidade().getId();
        this.empenho = anulacaoEmpenho.getEmpenho().getNumeroEmpenho();
        this.exercicio = exercicioAnulacao.getExercicio();
        this.sequencia = anulacaoEmpenho.getId();
        this.data = anulacaoEmpenho.getData();
        this.motivo = anulacaoEmpenho.getMotivoAnulacao();
        this.valor = anulacaoEmpenho.getSaldoAnulado();
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public Long getEmpenho() {
        return this.empenho;
    }

    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public String getUnidadeOrcamentaria() {
        return this.unidadeOrcamentaria;
    }

    public void setUnidadeOrcamentaria(String unidadeOrcamentaria) {
        this.unidadeOrcamentaria = unidadeOrcamentaria;
    }

    public Long getSequencia() {
        return this.sequencia;
    }

    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    public LocalDate getData() {
        return this.data;
    }

    public void setData(LocalDate data) {
        this.data = data;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public BigDecimal getValor() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valor);
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public EmpenhoAnulacaoDTO() {
    }
}

