SELECT R.LANCAMENTO, 
       R.DATA, 
       UPPER(TE.DESCRICAO) AS DESCRICAO, 
       R.BANCO, 
       R.AGENCIA, 
       R.CONTA, 
       R.CONTRIBUINTE, 
       R.CNPJ, 
       R.VALOR 
  FROM ${db.contabilidade.schema}.REALIZACAORECEITA R
  LEFT JOIN ${db.contabilidade.schema}.EXERCICIO EX
    ON R.ENTIDADE = EX.ENTIDADE 
   AND R.EXERCICIO = EX.EXERCICIO 
  LEFT JOIN ${db.contabilidade.schema}.TABELAEVENTO TE
    ON R.ENTIDADE = TE.ENTIDADE 
   AND R.EXERCICIO = TE.EXERCICIO 
   AND TE.MODELO = EX.MODELOPLANO 
   AND R.TIPOEVENTO = TE.TIPOEVENTO 
   AND R.GRUPOEVENTO = TE.GRUPOEVENTO 
   AND R.EVENTO = TE.EVENTO 
 WHERE R.ENTIDADE = :entidade
   AND R.EXERCICIO = :exercicio
   AND R.RECEITA = :receita
   AND R.DATA = :data
       $[FILTRO]