SELECT 
       MOV_GARAGEM.ENTIDADE,
       MOV_GARAGEM.EXERCICIO,
       MOV_GARAGEM.NUMERO,
       MOV_GARAGEM.DATASAIDA AS DATASAIDA,
       MOV_GARAGEM.HORASAIDA AS HORASAIDA,
       MOV_GARAGEM.DATARETORNO,
       MOV_GARAGEM.HORARETORNO,
       MOV_GARAGEM.MEDICAOSAIDA AS MEDIDORSAIDA,
       MOV_GARAGEM.MEDICAORETORNO AS MEDIDORRETORNO,
       MOV_GARAGEM.KMPREVISTA AS KMPREVISTO,
       MOV_GARAGEM.OBSERVACAO AS OBSERVACAO,
       MOV_GARAGEM.JUSTIFICATIVA AS JUSTIFICATIVA,
       MOV_GARAGEM.VEICULO AS VEICULONUMERO,
       VEICULO.DESCRICAO AS VEICULODESCRICAO,
       VEICULO.LETRAPLACA || '-' || VEICULO.NUMEROPLACA AS PLACA,
       MOTORISTA.NOME AS MOTORISTA,
       RESPONSAVEL.NOME AS SOLICITANTE,
       DESTINO.DESCRICAO AS DESTINO,
       MOV_GARAGEM.DESTINO_COMPLEMENTO AS COMPLEMENTODESTINO,
       MOTIVO.DESCRICAO AS MOTIVO,
       MOV_GARAGEM.MOTIVO_COMPLEMENTO AS COMPLEMENTOMOTIVO
  FROM ${db.contabilidade.schema}.FR_GARAGEM MOV_GARAGEM
 INNER JOIN ${db.contabilidade.schema}.PAT_VEICULO VEICULO
    ON VEICULO.ENTIDADE = MOV_GARAGEM.ENTIDADE
   AND VEICULO.BEM = MOV_GARAGEM.VEICULO
 INNER JOIN ${db.contabilidade.schema}.FR_MOTORISTAS MOTORISTA
    ON MOTORISTA.ENTIDADE = MOV_GARAGEM.ENTIDADE
   AND MOTORISTA.CODIGO = MOV_GARAGEM.MOTORISTA
  LEFT OUTER JOIN ${db.contabilidade.schema}.FR_DESTINO DESTINO
    ON DESTINO.CODIGO = MOV_GARAGEM.DESTINO
  LEFT OUTER JOIN ${db.contabilidade.schema}.PAT_RESPONSAVEL RESPONSAVEL
    ON RESPONSAVEL.RESPONSAVEL = MOV_GARAGEM.SOLICITADOPOR 
   AND RESPONSAVEL.ENTIDADE = MOV_GARAGEM.ENTIDADE
  LEFT OUTER JOIN ${db.contabilidade.schema}.FR_MOTIVO MOTIVO
    ON MOTIVO.CODIGO = MOV_GARAGEM.MOTIVO
 WHERE MOV_GARAGEM.ENTIDADE = :entidade
   AND MOV_GARAGEM.EXERCICIO = :exercicio
