/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.portaltransparencia.protocportal.domain.PROTOCEntidade;
import br.com.elotech.portaltransparencia.protocportal.domain.ProcessoPK;
import br.com.elotech.portaltransparencia.protocportal.domain.TipoProcesso;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Embeddable
public class ProcessoPK
implements Serializable {
    @ManyToOne
    @JoinColumn(name="entidade")
    private PROTOCEntidade entidade;
    @NotNull
    @EloSequence(schema="protocolo")
    private Long numero;
    @NotNull
    @ManyToOne
    private TipoProcesso tipo;
    @NotNull
    private Long ano;

    public static ProcessoPK of(PROTOCEntidade entidade, TipoProcesso tipo, Long numero, Long ano) {
        ProcessoPK pk = new ProcessoPK();
        pk.setEntidade(entidade);
        pk.setTipo(tipo);
        pk.setNumero(numero);
        pk.setAno(ano);
        return pk;
    }

    public String getKey() {
        if (this.isValidKey().booleanValue()) {
            return String.format("?tipo=%d&numero=%d&ano=%d", this.tipo.getId(), this.numero, this.ano);
        }
        return "";
    }

    public Boolean isValidKey() {
        return this.possuiTipoValido() && Objects.nonNull(this.numero) && Objects.nonNull(this.ano);
    }

    private boolean possuiTipoValido() {
        return Objects.nonNull(this.tipo) && Objects.nonNull(this.tipo.getId());
    }

    @Generated
    public static ProcessoPKBuilder builder() {
        return new ProcessoPKBuilder();
    }

    @Generated
    public PROTOCEntidade getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getNumero() {
        return this.numero;
    }

    @Generated
    public TipoProcesso getTipo() {
        return this.tipo;
    }

    @Generated
    public Long getAno() {
        return this.ano;
    }

    @Generated
    public void setEntidade(PROTOCEntidade entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setTipo(TipoProcesso tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setAno(Long ano) {
        this.ano = ano;
    }

    @Generated
    public ProcessoPK() {
    }

    @Generated
    public ProcessoPK(PROTOCEntidade entidade, Long numero, TipoProcesso tipo, Long ano) {
        this.entidade = entidade;
        this.numero = numero;
        this.tipo = tipo;
        this.ano = ano;
    }

    @Generated
    public String toString() {
        return "ProcessoPK(entidade=" + this.getEntidade() + ", numero=" + this.getNumero() + ", tipo=" + this.getTipo() + ", ano=" + this.getAno() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessoPK)) {
            return false;
        }
        ProcessoPK other = (ProcessoPK)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PROTOCEntidade this$entidade = this.getEntidade();
        PROTOCEntidade other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !this$entidade.equals(other$entidade)) {
            return false;
        }
        Long this$numero = this.getNumero();
        Long other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !((Object)this$numero).equals(other$numero)) {
            return false;
        }
        TipoProcesso this$tipo = this.getTipo();
        TipoProcesso other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        Long this$ano = this.getAno();
        Long other$ano = other.getAno();
        return !(this$ano == null ? other$ano != null : !((Object)this$ano).equals(other$ano));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessoPK;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PROTOCEntidade $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : $entidade.hashCode());
        Long $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : ((Object)$numero).hashCode());
        TipoProcesso $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        Long $ano = this.getAno();
        result = result * 59 + ($ano == null ? 43 : ((Object)$ano).hashCode());
        return result;
    }
}

