/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.mapper;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioBem;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioBemDTO;
import java.util.function.Function;
import org.springframework.core.convert.converter.Converter;

public class PatrimonioBemToDTO
implements Converter<PatrimonioBem, PatrimonioBemDTO>,
Function<PatrimonioBem, PatrimonioBemDTO> {
    public PatrimonioBemDTO convert(PatrimonioBem patrimonioBem) {
        PatrimonioBemDTO patrimonioBemDTO = new PatrimonioBemDTO();
        patrimonioBemDTO.setBem(patrimonioBem.getId().getBem());
        patrimonioBemDTO.setEntidade(patrimonioBem.getId().getEntidade());
        patrimonioBemDTO.setDescricao(patrimonioBem.getDescricao());
        patrimonioBemDTO.setTipoIncorporacao(patrimonioBem.getIncorporacao());
        patrimonioBemDTO.setTipo(patrimonioBem.getId().getTipo());
        patrimonioBemDTO.setChapa(patrimonioBem.getId().getChapa());
        patrimonioBemDTO.setValorAtual(patrimonioBem.getValorAtual());
        patrimonioBemDTO.setLocalAtual(patrimonioBem.getLocalAtual());
        patrimonioBemDTO.setDataAquisicao(patrimonioBem.getDataAquisicao());
        patrimonioBemDTO.setNotaFiscal(patrimonioBem.getNotaFiscal());
        patrimonioBemDTO.setBaixado(new BooleanToStringConverter().convertToDatabaseColumn(patrimonioBem.getBaixado()));
        patrimonioBemDTO.setNumeroFrota(patrimonioBem.getNumeroFrota());
        return patrimonioBemDTO;
    }

    @Override
    public PatrimonioBemDTO apply(PatrimonioBem patrimonio) {
        return this.convert(patrimonio);
    }
}

