SELECT DI.ENTIDADE,
       DI.EXERCICIO,
       DI.EMPENHO,
       DI.ENTIDADEEMPENHO,
       DI.EXERCICIOEMPENHO,
       DI.NUMEROLIQUIDACAO,
       DI.UNIDADEORCAMENTARIA,
       DI.NOME,
       DI.DATASAIDA,
       DI.DESTINO,
       DI.DATARETORNO,
       DI.QUANTIDADEDIARIAS,
       DI.VALORDIARIAS,
       DI.MEIOTRANSPORTE,
       DI.VALORPASSAGEM,
       DI.MOTIVO,
       DI.CARGO,
	   DI.MATRICULA,
       DI.NUMEROPROCESSO,
       DI.ANOPROCESSO,
       DI.LOTACAO,
       DI.HORASAIDA,
	   DI.HORARETORNO,
       DI.VALOREMPENHO,
       DI.VALORANULADO,
       DI.QUANTIDADEANULACOES,
       DI.SECRETARIA,
       DI.LABELCARGO,
       DI.IDTIPOOBJETIVODIARIA,
       DI.TIPOOBJETIVODIARIA,
       DI.VALORHOSPEDAGEM,
       DI.VALOREVENTO,
	   DI.NOATO,
	   DI.DATAATO,
	   DI.GASTOSTOTAIS   
  FROM (
SELECT D.ENTIDADE,
       D.EXERCICIO,
       D.EMPENHO,
       E.ENTIDADE AS ENTIDADEEMPENHO,
       E.EXERCICIO AS EXERCICIOEMPENHO,
       D.NOLIQUIDACAO AS NUMEROLIQUIDACAO,
       D.UNIDADEORCAMENTARIA,
       F.NOME,
       D.DATASAIDA,
       ( D.DESTINO || ' / ' || 
              COALESCE((SELECT G.UNIDADEFEDERACAO
			              FROM ${db.contabilidade.schema}.CIDADE G
						 WHERE G.CIDADE = D.IDCIDADEDESTINO),' ')) AS DESTINO,
       D.DATARETORNO,
       D.QTDEDIARIAS AS QUANTIDADEDIARIAS,
       COALESCE(L.VALOR, D.VLRDIARIAS) AS VALORDIARIAS,
       D.MEIOTRANSPORTE,
       D.VALORPASSAGEM,
       D.MOTIVO,
       D.CARGO,
	   D.MATRICULA,
       E.NOPROCESSO AS NUMEROPROCESSO,
       E.ANOPROCESSO,
       D.LOTACAO,
       D.HORASAIDA,       
	   D.HORARETORNO,
       (SELECT SUM(A.VALOR) FROM ${db.contabilidade.schema}.FICHAEMPENHO A
          WHERE D.ENTIDADE = A.ENTIDADE
            AND D.EXERCICIO = A.EXERCICIO
            AND D.EMPENHO = A.EMPENHO
            AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
       ) AS VALOREMPENHO,
       (SELECT SUM(A.VALORANULACOES - A.VALORESTANULACOES) FROM ${db.contabilidade.schema}.FICHAEMPENHO A
          WHERE D.ENTIDADE = A.ENTIDADE
            AND D.EXERCICIO = A.EXERCICIO
            AND D.EMPENHO = A.EMPENHO
            AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
       ) AS VALORANULADO,
       (SELECT COUNT(A.EMPENHO)
          FROM ${db.contabilidade.schema}.FICHAEMPENHO A
         WHERE D.ENTIDADE = A.ENTIDADE
           AND D.EXERCICIO = A.EXERCICIO
           AND D.EMPENHO = A.EMPENHO
           AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
           AND (SELECT SUM(A.VALOR - (A.VALORANULACOES - A.VALORESTANULACOES)) FROM ${db.contabilidade.schema}.FICHAEMPENHO A
                  WHERE D.ENTIDADE = A.ENTIDADE
                    AND D.EXERCICIO = A.EXERCICIO
                    AND D.EMPENHO = A.EMPENHO
                    AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
               ) < 0.01
       ) AS QUANTIDADEANULACOES,
       ORC.DESCRICAO AS SECRETARIA,
       CASE 
          WHEN P.VALOR = 'N' THEN 'Nome do Proponente'
          WHEN P.VALOR = 'C' THEN 'Cargo do Beneficiado'
          ELSE 'Cargo do Proponente'
       END AS LABELCARGO,
       D.IDTIPOOBJETIVODIARIA,
       T.DSTIPOOBJETIVODIARIA AS TIPOOBJETIVODIARIA,
       D.VLRHOSPEDAGEM AS VALORHOSPEDAGEM,
       D.VLREVENTO AS VALOREVENTO,
	   D.NOATO,
	   LA.DATA AS DATAATO,
	   SUM(COALESCE(D.VLRHOSPEDAGEM,0) + COALESCE(D.VLREVENTO,0) + COALESCE(L.VALOR, D.VLRDIARIAS) + COALESCE(D.VALORPASSAGEM,0)) AS GASTOSTOTAIS,
       D.IDSITUACAOASSINATURAELETRONICA,
       SAE.IDTIPOSITUACAO
  FROM ${db.contabilidade.schema}.DIARIA D
  LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
    ON D.ENTIDADE = E.ENTIDADE
   AND D.EXERCICIO = E.EXERCICIO
   AND D.EMPENHO = E.EMPENHO
   AND D.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA
  LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR F
    ON E.FORNECEDOR = F.FORNECEDOR
  LEFT OUTER JOIN ${db.contabilidade.schema}.ORCPARAMETRODESPESA ORC
    ON ORC.CODIGO = SUBSTR(E.PROGRAMATICA,1, 5)
   AND ORC.ENTIDADE = E.ENTIDADE
   AND ORC.EXERCICIO = E.EXERCICIO
  LEFT OUTER JOIN ${db.contabilidade.schema}.PARAMETROS P
    ON P.ENTIDADE = D.ENTIDADE
   AND P.EXERCICIO = D.EXERCICIO
   AND P.MODULO = '3'
   AND P.CODIGO = 159
  LEFT JOIN ${db.contabilidade.schema}.TIPOOBJETIVODIARIA T
    ON T.ID = D.IDTIPOOBJETIVODIARIA   
  LEFT JOIN ${db.contabilidade.schema}.LIQUIDACAO L
    ON L.ENTIDADE = E.ENTIDADE
   AND L.EXERCICIO = E.EXERCICIO
   AND L.ANODOCORIGEM = E.EXERCICIO
   AND L.NODOCORIGEM = E.EMPENHO
   AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
   AND L.NOLIQUIDACAO = D.NOLIQUIDACAO
  LEFT JOIN ${db.contabilidade.schema}.LEIS_ATOS LA
    ON LA.ID = D.IDATO
  LEFT JOIN ${db.contabilidade.schema}.SITUACAOASSINATURAELETRONICA SAE
    ON SAE.ID = D.IDSITUACAOASSINATURAELETRONICA
GROUP BY D.ENTIDADE, D.EXERCICIO, D.EMPENHO,
         E.ENTIDADE, E.EXERCICIO, D.NOLIQUIDACAO,
         D.UNIDADEORCAMENTARIA,  F.NOME, D.DATASAIDA,
         D.DESTINO, D.IDCIDADEDESTINO, D.DATARETORNO, 
		 D.QTDEDIARIAS, COALESCE(L.VALOR, D.VLRDIARIAS),
         D.MEIOTRANSPORTE, D.VALORPASSAGEM,
         D.MOTIVO, D.CARGO, D.MATRICULA,
         E.NOPROCESSO, E.ANOPROCESSO, D.LOTACAO,
         D.HORASAIDA, D.HORARETORNO, ORC.DESCRICAO, D.IDTIPOOBJETIVODIARIA,
         T.DSTIPOOBJETIVODIARIA, D.VLRHOSPEDAGEM,
         D.VLREVENTO, D.NOATO, LA.DATA, P.VALOR,
         D.IDSITUACAOASSINATURAELETRONICA, SAE.IDTIPOSITUACAO ) DI
 WHERE  DI.EXERCICIO = :exercicio
   AND ((DI.VALORDIARIAS  > 0) OR DI.VALORDIARIAS IS NULL)
   AND NOT EXISTS (SELECT * 
	    			 FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO EL
   					WHERE EL.ENTIDADE = DI.ENTIDADE 
	 				  AND EL.EXERCICIO = DI.EXERCICIO
	 				  AND EL.ANODOCORIGEM = DI.EXERCICIOEMPENHO
	 				  AND EL.UNIDADEDOCORIGEM = DI.UNIDADEORCAMENTARIA
	 				  AND EL.NODOCORIGEM = DI.EMPENHO 
				      AND EL.NOLIQUIDACAO = DI.NUMEROLIQUIDACAO)   