SELECT CF.ENTIDADE, CF.CARGO, CF.QUADROSALARIAL, CF.GRUPOOCUPACIONAL, CF.NIVEL, 
       GOF.FAIXA, GOF.DESCRICAO AS FAIXADESC, GOF.VALOR, GOF.VALORGRATIFICACAO,
       C.DESCRICAO, CL.DESCRICAO AS TIPO, CF.QUADROSALARIAL, QS.DESCRICAO AS QUADROSALARIALDESC,
       GO.DESCRICAO AS GRUPOOCUPACIONALDESC, GN.DESCRICAO AS NIVELDESC, C.VAGAS AS VAGASTOTAL,
       C.OCUPADAS AS VAGASOCUPADAS
  FROM ${db.aise.schema}.RHCARGOFAIXA CF
 INNER JOIN ${db.aise.schema}.RHCARGO C
    ON CF.ENTIDADE = C.ENTIDADE
   AND CF.CARGO = C.CARGO  
  LEFT OUTER JOIN ${db.aise.schema}.RHCLASSIFICACAOCARGO CL
    ON CL.CLASSIFICACAO = C.CLASSIFICACAO
  LEFT OUTER JOIN ${db.aise.schema}.RHQUADROSALARIAL QS
    ON CF.ENTIDADE = QS.ENTIDADE
   AND CF.QUADROSALARIAL = QS.QUADROSALARIAL
  LEFT OUTER JOIN ${db.aise.schema}.RHGRUPOOCUPACIONAL GO
    ON CF.ENTIDADE = GO.ENTIDADE
   AND CF.QUADROSALARIAL = GO.QUADROSALARIAL
   AND CF.GRUPOOCUPACIONAL = GO.GRUPOOCUPACIONAL
  LEFT OUTER JOIN ${db.aise.schema}.RHGRUPOOCUPACIONALNIVEL GN
    ON CF.ENTIDADE = GN.ENTIDADE
   AND CF.QUADROSALARIAL = GN.QUADROSALARIAL
   AND CF.GRUPOOCUPACIONAL = GN.GRUPOOCUPACIONAL
   AND GN.NIVEL BETWEEN CF.NIVEL AND CF.NIVELFINAL
  LEFT OUTER JOIN ${db.aise.schema}.RHGRUPOOCUPACIONALFAIXA GOF
    ON GN.ENTIDADE = GOF.ENTIDADE
   AND GN.QUADROSALARIAL = GOF.QUADROSALARIAL
   AND GN.GRUPOOCUPACIONAL = GOF.GRUPOOCUPACIONAL
   AND GN.NIVEL = GOF.NIVEL
 WHERE CF.ENTIDADE = :entidade
   AND ${db.aise.schema}.FNC_GETNUMEROFAIXA(GOF.FAIXA, CF.PADRAONIVELINICIAL) >= ${db.aise.schema}.FNC_GETNUMEROFAIXA(CF.FAIXAINICIAL, CF.PADRAONIVELINICIAL)
   AND ${db.aise.schema}.FNC_GETNUMEROFAIXA(GOF.FAIXA, CF.PADRAONIVELINICIAL) <= ${db.aise.schema}.FNC_GETNUMEROFAIXA(CF.FAIXAFINAL, CF.PADRAONIVELINICIAL)
   AND CF.INICIOVALIDADE = (SELECT MAX(X.INICIOVALIDADE) 
                              FROM ${db.aise.schema}.RHCARGOFAIXA X
                             WHERE X.ENTIDADE = CF.ENTIDADE 
                               AND X.CARGO = CF.CARGO 
                               AND EXTRACT(YEAR FROM X.INICIOVALIDADE) <= :exercicio)
   AND GOF.INICIOVALIDADE = (SELECT MAX(GOFX.INICIOVALIDADE)
                               FROM ${db.aise.schema}.RHGRUPOOCUPACIONALFAIXA GOFX
                               JOIN ${db.aise.schema}.RHGRUPOOCUPACIONALCOMPETENCIA GOCX ON GOFX.ENTIDADE = GOCX.ENTIDADE
                                AND GOFX.QUADROSALARIAL = GOCX.QUADROSALARIAL
                                AND GOFX.GRUPOOCUPACIONAL = GOCX.GRUPOOCUPACIONAL
                                AND GOFX.NIVEL = GOCX.NIVEL
                                AND GOFX.INICIOVALIDADE = GOCX.INICIOVALIDADE
                              WHERE GOFX.ENTIDADE = GOF.ENTIDADE
                                AND GOFX.QUADROSALARIAL = GOF.QUADROSALARIAL
                                AND GOFX.GRUPOOCUPACIONAL = GOF.GRUPOOCUPACIONAL
                                AND GOFX.NIVEL = GOF.NIVEL
                                AND GOFX.FAIXA = GOF.FAIXA
                                AND GOCX.SITUACAO = 1
                                AND EXTRACT(YEAR FROM GOFX.INICIOVALIDADE) <= :exercicio)
