/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.almoxarifado.client.CentroCustoClient;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.CentroCustoDTO;
import br.com.elotech.portaltransparencia.contabportal.service.CentroCustoService;
import java.util.List;
import java.util.stream.Collectors;

public class CentroCustoServiceOxyImpl
implements CentroCustoService {
    private final CentroCustoClient client;
    private final PortalParametroService parametroService;

    public CentroCustoServiceOxyImpl(CentroCustoClient client, PortalParametroService parametroService) {
        this.client = client;
        this.parametroService = parametroService;
    }

    public List<CentroCustoDTO> findAllEstocadores(Long entidade, Long exercicio) {
        if (this.mostrarSomenteCentroCustoComMovimentacao(entidade, exercicio).booleanValue()) {
            return this.client.findByAtivoAndCentroDeOrigemAndComMovimentacaoAndEntidade(entidade).stream().map(CentroCustoDTO::fromOxyAdmDTO).collect(Collectors.toList());
        }
        return this.client.findByAtivoTrueAndCentroDeConsumoAndIdEntidadeOrderByIdCentroCusto(Boolean.FALSE, entidade).stream().map(CentroCustoDTO::fromOxyAdmDTO).collect(Collectors.toList());
    }

    public List<CentroCustoDTO> findAllConsumidores(Long entidade) {
        return this.client.findByAtivoTrueAndCentroDeConsumoAndIdEntidadeOrderByIdCentroCusto(Boolean.TRUE, entidade).stream().map(CentroCustoDTO::fromOxyAdmDTO).collect(Collectors.toList());
    }

    private Boolean mostrarSomenteCentroCustoComMovimentacao(Long entidade, Long exercicio) {
        String valorCentroCustoComMovimentacao = this.parametroService.getPortalParametroValor(entidade, exercicio, Parametros.PARAM_CENTROCUSTO_MOVIMENTACAO);
        return SimNao.toBoolean((String)valorCentroCustoComMovimentacao);
    }
}

