/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.ExercicioFeignClient;
import br.com.elotech.portaltransparencia.contabportal.domain.Exercicio;
import br.com.elotech.portaltransparencia.contabportal.domain.ExercicioPK;
import br.com.elotech.portaltransparencia.contabportal.service.ExercicioService;
import br.com.elotech.portaltransparencia.utils.ExercicioParamsUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class ExercicioOxyService
implements ExercicioService {
    private final ExercicioFeignClient exercicioFeignClient;
    private final ExercicioParamsUtils exercicioUtils;

    public ExercicioOxyService(ExercicioFeignClient exercicioFeignClient, ExercicioParamsUtils exercicioUtils) {
        this.exercicioFeignClient = exercicioFeignClient;
        this.exercicioUtils = exercicioUtils;
    }

    public List<Exercicio> getExercicios(Long idEntidade) {
        String anoInicial = String.format("exercicio=ge=%d", this.exercicioUtils.getAnoInicial(idEntidade));
        String anoFinal = String.format("exercicio=le=%d", this.exercicioUtils.getAnoFinal(idEntidade));
        String search = "entidade.id==" + idEntidade + " and " + anoInicial + " and " + anoFinal;
        return this.exercicioFeignClient.findAll(search, (Pageable)PageRequest.of((int)0, (int)9999)).getContent().stream().map(Exercicio::fromExercicioContabilidade).collect(Collectors.toList());
    }

    public Optional<Exercicio> findExercicioPadrao() {
        List exerciciosContabilidade = this.exercicioFeignClient.findAll(null, (Pageable)PageRequest.of((int)0, (int)9999, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"exercicio"}))).getContent().stream().map(Exercicio::fromExercicioContabilidade).collect(Collectors.toList());
        List exerciciosPrincipais = exerciciosContabilidade.stream().filter(Exercicio::isPrincipal).collect(Collectors.toList());
        if (exerciciosPrincipais.isEmpty() && !exerciciosContabilidade.isEmpty()) {
            return exerciciosContabilidade.stream().sorted(Comparator.comparing(Exercicio::getExercicio).reversed().thenComparing(Exercicio::getEntidadeId)).findFirst();
        }
        return Optional.ofNullable((Exercicio)exerciciosPrincipais.get(0));
    }

    public Exercicio findOne(ExercicioPK pk) {
        return null;
    }

    public Long findModeloDespesa(Long entidade, Long exercicio) {
        return null;
    }
}

