/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.oxy.adm.patrimonio.client.portal.PatrimonioOxyParams;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PatrimonioParams;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class PatrimonioParams {
    private Long entidade;
    private Long exercicio;
    private String tipo;
    private Long bem;
    private String chapa;
    private String descricao;
    private Long incorporacao;
    private BigDecimal valorInicial;
    private BigDecimal valorFinal;
    private String baixado;
    private String exportType;
    private Boolean comodato;
    private UUID idOperacaoOxy;
    private UUID idOxy;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataAquisicaoInicial;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataAquisicaoFinal;

    public String montaFiltro() {
        StringBuilder where = new StringBuilder();
        where.append(" WHERE A.ENTIDADE = :entidade ");
        if (Objects.nonNull(this.tipo)) {
            where.append(" AND A.TIPO = :tipo");
        }
        if (Objects.nonNull(this.bem)) {
            where.append(" AND A.BEM = :bem");
        }
        if (Objects.nonNull(this.chapa)) {
            where.append(" AND UPPER(A.CHAPA) LIKE UPPER(:chapa)");
        }
        if (Objects.nonNull(this.descricao)) {
            where.append(" AND UPPER(A.DESCRICAO) LIKE UPPER(:descricao)");
        }
        if (Objects.nonNull(this.incorporacao)) {
            where.append(" AND A.INCORPORACAO = :incorporacao");
        }
        if (Objects.nonNull(this.valorInicial)) {
            where.append(" AND A.VALORATUAL >= :valorInicial");
        }
        if (Objects.nonNull(this.valorFinal)) {
            where.append(" AND A.VALORATUAL <= :valorFinal");
        }
        if (Objects.nonNull(this.dataAquisicaoInicial)) {
            where.append(" AND A.DATAAQUISICAO >= :dataAquisicaoInicial");
        }
        if (Objects.nonNull(this.dataAquisicaoFinal)) {
            where.append(" AND A.DATAAQUISICAO <= :dataAquisicaoFinal");
        }
        if (StringUtils.isNotBlank((String)this.baixado)) {
            where.append(" AND A.BAIXADO = :baixado");
        }
        if (Boolean.TRUE.equals(this.comodato)) {
            where.append(" AND A.COMODATO IS NOT NULL");
        }
        return where.toString();
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addTipo(params);
        this.addBem(params);
        this.addChapa(params);
        this.addDescricao(params);
        this.addIncorporacao(params);
        this.addValorInicial(params);
        this.addValorFinal(params);
        this.addDataAquisicaoInicial(params);
        this.addDataAquisicaoFinal(params);
        this.addBaixado(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addTipo(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipo)) {
            params.addValue("tipo", (Object)this.tipo, 12);
        }
    }

    private void addBem(MapSqlParameterSource params) {
        if (Objects.nonNull(this.bem)) {
            params.addValue("bem", (Object)this.bem, 2);
        }
    }

    private void addChapa(MapSqlParameterSource params) {
        if (Objects.nonNull(this.chapa)) {
            params.addValue("chapa", (Object)this.chapa, 12);
        }
    }

    private void addDataAquisicaoFinal(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataAquisicaoFinal)) {
            params.addValue("dataAquisicaoFinal", (Object)DateUtils.fromLocalDate((LocalDate)this.dataAquisicaoFinal), 91);
        }
    }

    private void addDataAquisicaoInicial(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataAquisicaoInicial)) {
            params.addValue("dataAquisicaoInicial", (Object)DateUtils.fromLocalDate((LocalDate)this.dataAquisicaoInicial), 91);
        }
    }

    private void addValorFinal(MapSqlParameterSource params) {
        if (Objects.nonNull(this.valorFinal)) {
            params.addValue("valorFinal", (Object)this.valorFinal, 8);
        }
    }

    private void addValorInicial(MapSqlParameterSource params) {
        if (Objects.nonNull(this.valorInicial)) {
            params.addValue("valorInicial", (Object)this.valorInicial, 8);
        }
    }

    private void addIncorporacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.incorporacao)) {
            params.addValue("incorporacao", (Object)this.incorporacao, 2);
        }
    }

    private void addDescricao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.descricao)) {
            params.addValue("descricao", (Object)("%" + this.descricao + "%"), 12);
        }
    }

    private void addBaixado(MapSqlParameterSource params) {
        if (StringUtils.isNotBlank((String)this.baixado)) {
            params.addValue("baixado", (Object)this.baixado, 12);
        }
    }

    public PatrimonioOxyParams toOxy() {
        PatrimonioOxyParams patrimonioOxyParams = new PatrimonioOxyParams();
        patrimonioOxyParams.setEntidade(this.getEntidade());
        patrimonioOxyParams.setExercicio(this.getExercicio());
        patrimonioOxyParams.setTipo(this.getTipo());
        patrimonioOxyParams.setBem(this.getBem());
        patrimonioOxyParams.setChapa(this.getChapa());
        patrimonioOxyParams.setDescricao(this.getDescricao());
        patrimonioOxyParams.setIncorporacao(this.getIncorporacao());
        patrimonioOxyParams.setValorInicial(this.getValorInicial());
        patrimonioOxyParams.setValorFinal(this.getValorFinal());
        patrimonioOxyParams.setBaixado(this.getBaixado());
        patrimonioOxyParams.setExportType(this.getExportType());
        patrimonioOxyParams.setComodato(this.getComodato());
        patrimonioOxyParams.setDataAquisicaoInicial(this.getDataAquisicaoInicial());
        patrimonioOxyParams.setDataAquisicaoFinal(this.getDataAquisicaoFinal());
        patrimonioOxyParams.setIdBemOxy(this.getIdOxy());
        patrimonioOxyParams.setIdOperacaoOxy(this.getIdOperacaoOxy());
        return patrimonioOxyParams;
    }

    @Generated
    public static PatrimonioParamsBuilder builder() {
        return new PatrimonioParamsBuilder();
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getTipo() {
        return this.tipo;
    }

    @Generated
    public Long getBem() {
        return this.bem;
    }

    @Generated
    public String getChapa() {
        return this.chapa;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getIncorporacao() {
        return this.incorporacao;
    }

    @Generated
    public BigDecimal getValorInicial() {
        return this.valorInicial;
    }

    @Generated
    public BigDecimal getValorFinal() {
        return this.valorFinal;
    }

    @Generated
    public String getBaixado() {
        return this.baixado;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public Boolean getComodato() {
        return this.comodato;
    }

    @Generated
    public UUID getIdOperacaoOxy() {
        return this.idOperacaoOxy;
    }

    @Generated
    public UUID getIdOxy() {
        return this.idOxy;
    }

    @Generated
    public LocalDate getDataAquisicaoInicial() {
        return this.dataAquisicaoInicial;
    }

    @Generated
    public LocalDate getDataAquisicaoFinal() {
        return this.dataAquisicaoFinal;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setBem(Long bem) {
        this.bem = bem;
    }

    @Generated
    public void setChapa(String chapa) {
        this.chapa = chapa;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setIncorporacao(Long incorporacao) {
        this.incorporacao = incorporacao;
    }

    @Generated
    public void setValorInicial(BigDecimal valorInicial) {
        this.valorInicial = valorInicial;
    }

    @Generated
    public void setValorFinal(BigDecimal valorFinal) {
        this.valorFinal = valorFinal;
    }

    @Generated
    public void setBaixado(String baixado) {
        this.baixado = baixado;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public void setComodato(Boolean comodato) {
        this.comodato = comodato;
    }

    @Generated
    public void setIdOperacaoOxy(UUID idOperacaoOxy) {
        this.idOperacaoOxy = idOperacaoOxy;
    }

    @Generated
    public void setIdOxy(UUID idOxy) {
        this.idOxy = idOxy;
    }

    @Generated
    public void setDataAquisicaoInicial(LocalDate dataAquisicaoInicial) {
        this.dataAquisicaoInicial = dataAquisicaoInicial;
    }

    @Generated
    public void setDataAquisicaoFinal(LocalDate dataAquisicaoFinal) {
        this.dataAquisicaoFinal = dataAquisicaoFinal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatrimonioParams)) {
            return false;
        }
        PatrimonioParams other = (PatrimonioParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        Long this$bem = this.getBem();
        Long other$bem = other.getBem();
        if (this$bem == null ? other$bem != null : !((Object)this$bem).equals(other$bem)) {
            return false;
        }
        String this$chapa = this.getChapa();
        String other$chapa = other.getChapa();
        if (this$chapa == null ? other$chapa != null : !this$chapa.equals(other$chapa)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        Long this$incorporacao = this.getIncorporacao();
        Long other$incorporacao = other.getIncorporacao();
        if (this$incorporacao == null ? other$incorporacao != null : !((Object)this$incorporacao).equals(other$incorporacao)) {
            return false;
        }
        BigDecimal this$valorInicial = this.getValorInicial();
        BigDecimal other$valorInicial = other.getValorInicial();
        if (this$valorInicial == null ? other$valorInicial != null : !((Object)this$valorInicial).equals(other$valorInicial)) {
            return false;
        }
        BigDecimal this$valorFinal = this.getValorFinal();
        BigDecimal other$valorFinal = other.getValorFinal();
        if (this$valorFinal == null ? other$valorFinal != null : !((Object)this$valorFinal).equals(other$valorFinal)) {
            return false;
        }
        String this$baixado = this.getBaixado();
        String other$baixado = other.getBaixado();
        if (this$baixado == null ? other$baixado != null : !this$baixado.equals(other$baixado)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        if (this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType)) {
            return false;
        }
        Boolean this$comodato = this.getComodato();
        Boolean other$comodato = other.getComodato();
        if (this$comodato == null ? other$comodato != null : !((Object)this$comodato).equals(other$comodato)) {
            return false;
        }
        UUID this$idOperacaoOxy = this.getIdOperacaoOxy();
        UUID other$idOperacaoOxy = other.getIdOperacaoOxy();
        if (this$idOperacaoOxy == null ? other$idOperacaoOxy != null : !((Object)this$idOperacaoOxy).equals(other$idOperacaoOxy)) {
            return false;
        }
        UUID this$idOxy = this.getIdOxy();
        UUID other$idOxy = other.getIdOxy();
        if (this$idOxy == null ? other$idOxy != null : !((Object)this$idOxy).equals(other$idOxy)) {
            return false;
        }
        LocalDate this$dataAquisicaoInicial = this.getDataAquisicaoInicial();
        LocalDate other$dataAquisicaoInicial = other.getDataAquisicaoInicial();
        if (this$dataAquisicaoInicial == null ? other$dataAquisicaoInicial != null : !((Object)this$dataAquisicaoInicial).equals(other$dataAquisicaoInicial)) {
            return false;
        }
        LocalDate this$dataAquisicaoFinal = this.getDataAquisicaoFinal();
        LocalDate other$dataAquisicaoFinal = other.getDataAquisicaoFinal();
        return !(this$dataAquisicaoFinal == null ? other$dataAquisicaoFinal != null : !((Object)this$dataAquisicaoFinal).equals(other$dataAquisicaoFinal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PatrimonioParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        Long $bem = this.getBem();
        result = result * 59 + ($bem == null ? 43 : ((Object)$bem).hashCode());
        String $chapa = this.getChapa();
        result = result * 59 + ($chapa == null ? 43 : $chapa.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        Long $incorporacao = this.getIncorporacao();
        result = result * 59 + ($incorporacao == null ? 43 : ((Object)$incorporacao).hashCode());
        BigDecimal $valorInicial = this.getValorInicial();
        result = result * 59 + ($valorInicial == null ? 43 : ((Object)$valorInicial).hashCode());
        BigDecimal $valorFinal = this.getValorFinal();
        result = result * 59 + ($valorFinal == null ? 43 : ((Object)$valorFinal).hashCode());
        String $baixado = this.getBaixado();
        result = result * 59 + ($baixado == null ? 43 : $baixado.hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        Boolean $comodato = this.getComodato();
        result = result * 59 + ($comodato == null ? 43 : ((Object)$comodato).hashCode());
        UUID $idOperacaoOxy = this.getIdOperacaoOxy();
        result = result * 59 + ($idOperacaoOxy == null ? 43 : ((Object)$idOperacaoOxy).hashCode());
        UUID $idOxy = this.getIdOxy();
        result = result * 59 + ($idOxy == null ? 43 : ((Object)$idOxy).hashCode());
        LocalDate $dataAquisicaoInicial = this.getDataAquisicaoInicial();
        result = result * 59 + ($dataAquisicaoInicial == null ? 43 : ((Object)$dataAquisicaoInicial).hashCode());
        LocalDate $dataAquisicaoFinal = this.getDataAquisicaoFinal();
        result = result * 59 + ($dataAquisicaoFinal == null ? 43 : ((Object)$dataAquisicaoFinal).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PatrimonioParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipo=" + this.getTipo() + ", bem=" + this.getBem() + ", chapa=" + this.getChapa() + ", descricao=" + this.getDescricao() + ", incorporacao=" + this.getIncorporacao() + ", valorInicial=" + this.getValorInicial() + ", valorFinal=" + this.getValorFinal() + ", baixado=" + this.getBaixado() + ", exportType=" + this.getExportType() + ", comodato=" + this.getComodato() + ", idOperacaoOxy=" + this.getIdOperacaoOxy() + ", idOxy=" + this.getIdOxy() + ", dataAquisicaoInicial=" + this.getDataAquisicaoInicial() + ", dataAquisicaoFinal=" + this.getDataAquisicaoFinal() + ")";
    }

    @Generated
    public PatrimonioParams() {
    }

    @Generated
    public PatrimonioParams(Long entidade, Long exercicio, String tipo, Long bem, String chapa, String descricao, Long incorporacao, BigDecimal valorInicial, BigDecimal valorFinal, String baixado, String exportType, Boolean comodato, UUID idOperacaoOxy, UUID idOxy, LocalDate dataAquisicaoInicial, LocalDate dataAquisicaoFinal) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.tipo = tipo;
        this.bem = bem;
        this.chapa = chapa;
        this.descricao = descricao;
        this.incorporacao = incorporacao;
        this.valorInicial = valorInicial;
        this.valorFinal = valorFinal;
        this.baixado = baixado;
        this.exportType = exportType;
        this.comodato = comodato;
        this.idOperacaoOxy = idOperacaoOxy;
        this.idOxy = idOxy;
        this.dataAquisicaoInicial = dataAquisicaoInicial;
        this.dataAquisicaoFinal = dataAquisicaoFinal;
    }
}

