/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.mapper;

import br.com.elotech.portaltransparencia.contabportal.domain.dto.AvaliacaoPPADTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AvaliacaoPPAFuncaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AvaliacaoPPAProgramaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AvaliacaoPPAUnidadeDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AvaliacaoPpaTreeDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class AvaliacaoPpaToTree
implements Function<List<AvaliacaoPPAProgramaDTO>, AvaliacaoPPADTO> {
    @Override
    public AvaliacaoPPADTO apply(List<AvaliacaoPPAProgramaDTO> projetos) {
        ArrayList tree = new ArrayList();
        projetos.stream().filter(projetoDTO -> this.filtrarProjetos(tree, projetoDTO)).forEach(projetoDTO -> tree.add(new AvaliacaoPpaTreeDTO(projetoDTO.getProjeto(), projetoDTO.getDescricaoProjeto())));
        tree.stream().forEach(projetoTree -> this.montarArvorePorProjeto(projetos, projetoTree));
        BigDecimal totalExecutado = projetos.stream().map(AvaliacaoPPAProgramaDTO::getValorExecutado).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalPlanejado = projetos.stream().map(AvaliacaoPPAProgramaDTO::getValorPlanejado).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalPlanejadoAtualizado = projetos.stream().map(AvaliacaoPPAProgramaDTO::getValorPlanejadoAtualizado).reduce(BigDecimal.ZERO, BigDecimal::add);
        AvaliacaoPPADTO avaliacaoPPA = new AvaliacaoPPADTO();
        avaliacaoPPA.getProjetos().addAll(tree);
        avaliacaoPPA.setSomaExecutado(totalExecutado);
        avaliacaoPPA.setSomaPlanejado(totalPlanejado);
        avaliacaoPPA.setSomaAtualizado(totalPlanejadoAtualizado);
        return avaliacaoPPA;
    }

    private void montarArvorePorProjeto(List<AvaliacaoPPAProgramaDTO> projetos, AvaliacaoPpaTreeDTO projetoTree) {
        ArrayList unidades = new ArrayList();
        projetos.stream().filter(projetoDTO -> this.filtrarUnidadesPorProjeto(projetoTree, unidades, projetoDTO)).forEach(projetoDTO -> unidades.add(new AvaliacaoPPAUnidadeDTO(projetoDTO.getUnidade(), projetoDTO.getProjeto())));
        projetoTree.getUnidades().addAll(unidades);
        projetoTree.getUnidades().stream().forEach(unidadeDTO -> this.montarArvorePorUnidade(projetos, unidadeDTO));
    }

    private void montarArvorePorUnidade(List<AvaliacaoPPAProgramaDTO> projetos, AvaliacaoPPAUnidadeDTO unidadeDTO) {
        ArrayList funcoes = new ArrayList();
        projetos.stream().filter(projetoDTO -> this.filtrarFuncoesPorUnidade(unidadeDTO, funcoes, projetoDTO)).forEach(projetoDTO -> funcoes.add(new AvaliacaoPPAFuncaoDTO(projetoDTO.getFuncao(), projetoDTO.getUnidade(), projetoDTO.getProjeto())));
        unidadeDTO.getFuncoes().addAll(funcoes);
        unidadeDTO.getFuncoes().stream().forEach(funcaoDTO -> this.montarArvorePorFuncao(projetos, funcaoDTO));
    }

    private void montarArvorePorFuncao(List<AvaliacaoPPAProgramaDTO> projetos, AvaliacaoPPAFuncaoDTO funcaoDTO) {
        ArrayList programas = new ArrayList();
        projetos.stream().filter(projetoDTO -> this.filtrarProgramaPorFuncao(funcaoDTO, programas, projetoDTO)).forEach(programas::add);
        funcaoDTO.getProgramas().addAll(programas);
    }

    private boolean filtrarProjetos(List<AvaliacaoPpaTreeDTO> tree, AvaliacaoPPAProgramaDTO projetoDTO) {
        return !this.possuiProjetoRepetido(tree, projetoDTO);
    }

    private boolean filtrarProgramaPorFuncao(AvaliacaoPPAFuncaoDTO funcaoDTO, List<AvaliacaoPPAProgramaDTO> programas, AvaliacaoPPAProgramaDTO projetoDTO) {
        return projetoDTO.getFuncao().equals(funcaoDTO.getCodigoFuncao()) && projetoDTO.getUnidade().equals(funcaoDTO.getCodigoUnidade()) && projetoDTO.getProjeto().equals(funcaoDTO.getCodigoProjeto()) && !this.possuiProgramaRepetido(programas, projetoDTO);
    }

    private boolean filtrarFuncoesPorUnidade(AvaliacaoPPAUnidadeDTO unidadeDTO, List<AvaliacaoPPAFuncaoDTO> funcoes, AvaliacaoPPAProgramaDTO projetoDTO) {
        return projetoDTO.getUnidade().equals(unidadeDTO.getCodigoUnidade()) && projetoDTO.getProjeto().equals(unidadeDTO.getCodigoProjeto()) && !this.possuiFuncaoRepetido(funcoes, projetoDTO);
    }

    private boolean filtrarUnidadesPorProjeto(AvaliacaoPpaTreeDTO projetoTree, List<AvaliacaoPPAUnidadeDTO> unidades, AvaliacaoPPAProgramaDTO projetoDTO) {
        return projetoDTO.getProjeto().equals(projetoTree.getCodigo()) && !this.possuiUnidadeRepetido(unidades, projetoDTO);
    }

    private boolean possuiProjetoRepetido(List<AvaliacaoPpaTreeDTO> tree, AvaliacaoPPAProgramaDTO projetoDTO) {
        for (AvaliacaoPpaTreeDTO projeto : tree) {
            if (!projeto.getCodigo().equals(projetoDTO.getProjeto())) continue;
            return true;
        }
        return false;
    }

    private boolean possuiUnidadeRepetido(List<AvaliacaoPPAUnidadeDTO> unidadesDTO, AvaliacaoPPAProgramaDTO projetoDTO) {
        for (AvaliacaoPPAUnidadeDTO unidadeDTO : unidadesDTO) {
            if (!unidadeDTO.getCodigoUnidade().equals(projetoDTO.getUnidade())) continue;
            return true;
        }
        return false;
    }

    private boolean possuiFuncaoRepetido(List<AvaliacaoPPAFuncaoDTO> funcoesDTO, AvaliacaoPPAProgramaDTO projetoDTO) {
        for (AvaliacaoPPAFuncaoDTO funcaoDTO : funcoesDTO) {
            if (!funcaoDTO.getCodigoFuncao().equals(projetoDTO.getFuncao())) continue;
            return true;
        }
        return false;
    }

    private boolean possuiProgramaRepetido(List<AvaliacaoPPAProgramaDTO> programasDTO, AvaliacaoPPAProgramaDTO projetoDTO) {
        for (AvaliacaoPPAProgramaDTO programaDTO : programasDTO) {
            if (!programaDTO.getPrograma().equals(projetoDTO.getPrograma()) || !programaDTO.getExercicio().equals(projetoDTO.getExercicio())) continue;
            return true;
        }
        return false;
    }
}

