SELECT EM.MES, 
       COALESCE(SUM(RD.VALORARRECADADO-RD.VALORESTARRECADADO-RD.VALORDEVOLUCAO+RD.VALORESTDEVOLUCAO),0) AS VALORARRECADADO 
  FROM ${db.contabilidade.schema}.RECEITA R
  LEFT JOIN ${db.contabilidade.schema}.ORCPARAMETRORECEITA PR
    ON R.ENTIDADE = PR.ENTIDADE 
   AND R.EXERCICIO = PR.EXERCICIO 
   AND R.MODELORECEITA = PR.MODELORECEITA 
   AND R.TIPO = PR.TIPO 
   AND R.NIVEL = PR.ORDEM 
   AND R.RECEITA = PR.CODIGO 
  LEFT JOIN ${db.contabilidade.schema}.EXERCICIO_MES EM
    ON R.ENTIDADE = EM.ENTIDADE 
   AND R.EXERCICIO = EM.EXERCICIO 
  LEFT JOIN ${db.contabilidade.schema}.RECEITADIARIA RD
    ON R.ENTIDADE = RD.ENTIDADE 
   AND R.EXERCICIO = RD.EXERCICIO 
   AND R.RECEITA = RD.RECEITA 
   AND R.FONTERECURSO = RD.FONTERECURSO
   AND R.IDTIPOOPERACAORECEITA = RD.IDTIPOOPERACAORECEITA 
   AND EM.MES = EXTRACT(MONTH FROM DATA)
 WHERE R.ENTIDADE = :entidade
   AND R.EXERCICIO = :exercicio
   AND R.RECEITA = :receita
       $[FILTRO]
 GROUP BY EM.MES 
 ORDER BY EM.MES