/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.service.impl;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.protocportal.domain.Escolaridade;
import br.com.elotech.portaltransparencia.protocportal.params.ConsultaProcessoEsicParams;
import br.com.elotech.portaltransparencia.protocportal.params.ConsultaProcessoParams;
import br.com.elotech.portaltransparencia.protocportal.params.SalvaProcessoParams;
import br.com.elotech.portaltransparencia.protocportal.service.ParametroService;
import br.com.elotech.portaltransparencia.protocportal.service.ProcessoService;
import br.com.elotech.protocolo.client.feign.ConsultaProcessoIntegracaoClientFeign;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ProcessoServiceOxyImpl
implements ProcessoService {
    private final ConsultaProcessoIntegracaoClientFeign client;
    private final ParametroService parametroService;

    public ProcessoServiceOxyImpl(ConsultaProcessoIntegracaoClientFeign client, ParametroService parametroService) {
        this.client = client;
        this.parametroService = parametroService;
    }

    public br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO consultaProcesso(ConsultaProcessoParams params) {
        PesquisaProcessoParams pesquisaProcessoParams = params.toOxyParams();
        Long tipo = Long.parseLong(this.parametroService.findTipoProcessoProtocoloOrThrow(params.getEntidade(), params.getExercicio()));
        pesquisaProcessoParams.setTipo(tipo);
        ProcessoDTO processoDTO = this.client.findOne(pesquisaProcessoParams.getEntidade(), pesquisaProcessoParams.getAno(), pesquisaProcessoParams.getTipo(), pesquisaProcessoParams.getNumero());
        return br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO.fromOxyProcesso((ProcessoDTO)Optional.ofNullable(processoDTO).orElse(new ProcessoDTO()));
    }

    public br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO salvaProcesso(SalvaProcessoParams params) {
        throw new NotImplementedException();
    }

    public Future<Boolean> enviaeSicEmail(br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO processo) {
        throw new NotImplementedException();
    }

    public Future<Boolean> enviaContatoEmail(br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO processo) {
        throw new NotImplementedException();
    }

    public Page<br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO> findProcessoByTipo(ConsultaProcessoEsicParams params, Pageable pageable) {
        Long tipoProcesso = Long.parseLong(this.parametroService.findTipoProcessoProtocoloOrThrow(params.getEntidade(), params.getExercicio()));
        StringBuilder searchBuilder = new StringBuilder(String.format("id.tipo.id==%s", tipoProcesso));
        if (params.getUsuario().isPresent() && StringUtils.isNotBlank((String)((String)params.getUsuario().get()))) {
            searchBuilder.append(String.format(" and usuarioRegistro==%s", params.getUsuario().get()));
        } else {
            searchBuilder.append(" and usuarioRegistro!='e-SIC'");
        }
        params.getDataInicial().ifPresent(item -> searchBuilder.append(String.format(" and dataProcesso>=%s", params.getDataInicial().get())));
        params.getDataFinal().ifPresent(item -> searchBuilder.append(String.format(" and dataProcesso<=%s", params.getDataFinal().get())));
        EloPage processosByTipo = this.client.findProcessosGeraisByAssunto(null, searchBuilder.toString(), params.getEntidade(), pageable);
        List content = processosByTipo.getContent();
        List processos = content.stream().map(br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO::fromOxyProcesso).collect(Collectors.toList());
        return new PageImpl(processos, pageable, processosByTipo.getTotalElements());
    }

    public List<Escolaridade> loadEscolaridades() {
        return new ArrayList<Escolaridade>();
    }
}

