 SELECT DISTINCT B.COTACAO,
        B.PESSOA, 
        P.NOME, 
        P.CNPJ_CPF AS CNPJCPF, 
        B.DATA, C.IDARQUIVO, 
        CASE WHEN C.NOMEARQUIVO IS NULL THEN ELOARQ.NOME ELSE C.NOMEARQUIVO END AS NOMEARQUIVO, 
        C.DATA AS DATAPUBLICACAO,
        LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO
   FROM ${db.compras.schema}.CLCOTACAO B
   LEFT JOIN ${db.compras.schema}.CLLICITACAO A
     ON A.ENTIDADE = B.ENTIDADE  
    AND A.EXERCICIO = B.EXERCICIO  
    AND A.COTACAO = B.COTACAO
   LEFT JOIN ${db.compras.schema}.CLANEXO AN
     ON B.entidade = AN.entidade
    AND B.anexo    = AN.CODIGOANEXO
   LEFT JOIN ${db.compras.schema}.CLANEXOITEM ANI
     ON ANI.entidade = AN.entidade
    AND ANI.codigoanexo = AN.codigoanexo
   LEFT JOIN ${db.compras.schema}.PESSOA P 
     ON B.PESSOA = P.PESSOA  
   LEFT JOIN ${db.compras.schema}.ARQUIVO C
     ON C.ID = B.IDARQUIVO  
   LEFT JOIN schema_eloarquivo.ARQUIVO ELOARQ
     ON ELOARQ.ID = C.IDARQUIVO
   LEFT JOIN schema_eloarquivo.ARQUIVO_CONTENT AC  
     ON C.IDARQUIVO = AC.ID  
  WHERE (A.ENTIDADE = :entidade AND A.EXERCICIO = :exercicio AND A.TIPOLICITACAO = :tipoLicitacao AND A.LICITACAO = :licitacao)
     OR (ANI.ENTIDADELICITACAO = :entidade AND ANI.EXERCICIOLICITACAO = :exercicio AND ANI.TIPOLICITACAO = :tipoLicitacao AND ANI.LICITACAO = :licitacao)
  ORDER BY P.NOME
