/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.service.impl;

import br.com.elotech.adm.compras.client.LicitacaoClient;
import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.comprasportal.domain.LicitacaoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AtaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CertidaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CotacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.MidiaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ParecerDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PrecoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PublicacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.RecursoArquivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.RecursoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.LicitacaoArquivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.repository.LicitacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.LicitacaoService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LicitacaoServiceImpl
implements LicitacaoService {
    private static final String RECURSOS = "db/sql/compras/recursos.sql";
    private static final String RECURSOARQUIVOS = "db/sql/compras/recursoArquivos.sql";
    private final Boolean isIntegradoOxy;
    private final LicitacaoRepository licitacaoRepository;
    private final LicitacaoArquivoRepository licitacaoArquivoRepository;
    private final EloArquivoRepository eloArquivoRepository;
    private final ArquivoService arquivoService;
    private final LicitacaoClient licitacaoClient;
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public LicitacaoServiceImpl(@Value(value="${elotech.integradooxy:false}") Boolean isIntegradoOxy, LicitacaoRepository licitacaoRepository, LicitacaoArquivoRepository licitacaoArquivoRepository, EloArquivoRepository eloArquivoRepository, ArquivoService arquivoService, LicitacaoClient licitacaoClient, DatasourceWrapper datasourceWrapper) {
        this.isIntegradoOxy = isIntegradoOxy;
        this.licitacaoRepository = licitacaoRepository;
        this.licitacaoArquivoRepository = licitacaoArquivoRepository;
        this.eloArquivoRepository = eloArquivoRepository;
        this.arquivoService = arquivoService;
        this.licitacaoClient = licitacaoClient;
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<LicitacaoDTO> findLicitacoes(FindLicitacaoParams findLicitacaoParams, Pageable pageable) {
        return this.licitacaoRepository.findLicitacoes(findLicitacaoParams, pageable);
    }

    public LicitacaoDTO findLicitacao(FindLicitacaoParams params) {
        return this.licitacaoRepository.findLicitacao(params);
    }

    public List<ParecerDTO> findPareceres(FindLicitacaoParams params) {
        return this.licitacaoRepository.findPareceres(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<MidiaLicitacaoDTO> findMidia(FindLicitacaoParams params) {
        return this.licitacaoRepository.findMidia(params);
    }

    public List<CotacaoLicitacaoDTO> findCotacoes(FindLicitacaoParams params) {
        return this.licitacaoRepository.findCotacoes(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<PublicacaoLicitacaoDTO> findPublicacoes(FindLicitacaoParams params) {
        return this.licitacaoRepository.findPublicacoes(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<AtaLicitacaoDTO> findAtas(FindLicitacaoParams params) {
        String nomeSchemaEloArquivo = this.arquivoService.getNomeSchemaEloArquivo();
        ArrayList<AtaLicitacaoDTO> list = new ArrayList<AtaLicitacaoDTO>();
        list.addAll(this.licitacaoRepository.findAtasRegistroPreco(params, nomeSchemaEloArquivo));
        list.addAll(this.licitacaoRepository.findAtasLicitacao(params, nomeSchemaEloArquivo));
        list.addAll(this.licitacaoRepository.findAtasSessaoPregao(params, nomeSchemaEloArquivo));
        return list;
    }

    public List<LicitacaoArquivo> findArquivos(FindLicitacaoParams params) {
        List<LicitacaoArquivo> licitacaoArquivos;
        if (!params.getTipoLicitacao().isPresent() && !params.getLicitacao().isPresent()) {
            return new ArrayList<LicitacaoArquivo>();
        }
        if (this.isIntegradoOxy.booleanValue()) {
            List arquivosOxy = this.licitacaoClient.findArquivos(params.getEntidade(), params.getExercicio(), (Long)params.getTipoLicitacao().get(), (Long)params.getLicitacao().get());
            licitacaoArquivos = arquivosOxy.stream().map(LicitacaoArquivo::fromLicitacaoArquivoOxy).collect(Collectors.toList());
        } else {
            licitacaoArquivos = this.licitacaoArquivoRepository.findByEntidadeAndExercicioAndTipoLicitacaoAndLicitacao(params.getEntidade(), params.getExercicio(), (Long)params.getTipoLicitacao().get(), (Long)params.getLicitacao().get());
            licitacaoArquivos.stream().filter(LicitacaoArquivo::possuiEloArquivo).map(LicitacaoArquivo::getArquivoCompras).forEach(arquivo -> {
                arquivo.setTamanhoArquivo(this.eloArquivoRepository.getTamanhoArquivo(arquivo.getArquivo().getId()));
                Arquivo arq = (Arquivo)this.eloArquivoRepository.getOne((Object)arquivo.getIdArquivo());
                if (Objects.isNull(arquivo.getData()) && Objects.nonNull(arq.getDataCriacao())) {
                    arquivo.setData(arq.getDataCriacao());
                }
            });
        }
        return licitacaoArquivos;
    }

    @Transactional
    public List<CertidaoLicitacaoDTO> findCertidoes(FindLicitacaoParams params) {
        return this.licitacaoRepository.findCertidoes(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<PrecoLicitacaoDTO> findPrecos(FindLicitacaoParams params) {
        return this.licitacaoRepository.findPrecos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<RecursoLicitacaoDTO> findRecursos(FindLicitacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)RECURSOS);
        String sqlArquivos = FileUtils.readResourceAsString((String)RECURSOARQUIVOS).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo());
        List recursos = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RecursoLicitacaoDTO.class));
        for (RecursoLicitacaoDTO recurso : recursos) {
            MapSqlParameterSource paramsWhere = new MapSqlParameterSource();
            paramsWhere.addValue("idchave", (Object)String.format("R%s", recurso.getId()), 12);
            recurso.getArquivos().addAll(this.datasourceWrapper.getJdbcTemplate().query(sqlArquivos, (SqlParameterSource)paramsWhere, (RowMapper)new ElotechBeanPropertyRowMapper(RecursoArquivoDTO.class)));
        }
        return recursos;
    }

    public List<UltimaAtualizacaoDTO> findUltimasAtualizacoes(FindExercicioParams params) {
        return this.licitacaoRepository.findUltimaAtualizacao(params);
    }
}

