/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaAtoDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaDadosServidorDTO;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.QuadroPessoalDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorResumoNaturezaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.EstagiarioDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.LeisAtosDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.LeisAtosNaturezaDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.LeisAtosParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.PortalTransparenciaVencimentosDescontosParamDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.QuadroPessoalDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorResumoNaturezaDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorVencimentosDescontosDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.aiseportal.service.IntegracaoOxyFolhaPagamentoService;
import br.com.elotech.portaltransparencia.contabportal.domain.Parametro;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosNaturezaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.ParametroRepositoryImpl;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LeisAtosParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoOxyFolhaPagamentoServiceImpl
implements IntegracaoOxyFolhaPagamentoService {
    private final ParametroRepositoryImpl parametroRepository;
    private final PortalParametroRepository portalParametroRepository;
    private final EntidadeAiseService entidadeAiseService;
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;

    public ParametroRepositoryImpl getParametroRepository() {
        return this.parametroRepository;
    }

    public List<ServidorResumoNaturezaDTO> servidoresPorClasse(ServidorParams params) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return Collections.emptyList();
        }
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        List totalServidoresPorClasse = this.integracaoFolhaPortalTransparenciaClient.getTotalServidoresPorClasse(params.getEntidadeAise(), params.getExercicio());
        if (Objects.nonNull(totalServidoresPorClasse)) {
            return totalServidoresPorClasse.stream().map(ServidorResumoNaturezaDTOConverter::toServidorResumoNaturezaDTO).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Page<ServidorDTO> loadServidores(ServidorParams params, Pageable pageable) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        EloPage servidores = this.integracaoFolhaPortalTransparenciaClient.getServidores(ServidorParamsConverter.toDTO((ServidorParams)params), pageable);
        return new PageImpl(servidores.getContent().stream().map(ServidorDTOConverter::portalTransparenciaServidoresDTOToServidorDTO).collect(Collectors.toList()), pageable, servidores.getTotalElements());
    }

    public Optional<ServidorDTO> dadosServidor(ServidorParams params) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return Optional.empty();
        }
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        return Optional.of(ServidorDTOConverter.portalTransparenciaDadosServidorDTOToServidorDTO((PortalTransparenciaDadosServidorDTO)this.integracaoFolhaPortalTransparenciaClient.getDadosServidor(params.getEntidadeAise(), params.getExercicio(), params.getMatricula())));
    }

    public List<String> getSituacoes(ServidorParams params) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return Collections.emptyList();
        }
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        return this.integracaoFolhaPortalTransparenciaClient.findSituacoes();
    }

    public boolean isParametroHabilitado(Long entidade, Long exercicio) {
        Parametro parametro = this.parametroRepository.findByEntidadeExercicioModuloAndCodigo(entidade, exercicio, ModuloEnum.MODULO_SISCOP.getValue(), Parametros.PARAM_HABILITA_INTEGRACAO_OXYFOLHA);
        return Objects.nonNull(parametro) && SimNao.SIM.getSigla().equalsIgnoreCase(parametro.getValor());
    }

    public List<ServidorVencimentosDescontosDTO> loadVencimentosOuDescontos(ServidorParams params) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return Collections.emptyList();
        }
        Boolean irrfPrevidenciaOutrosDescontos = this.getPortalParametroContabil(params, Parametros.PARAM_IRRF_PREVIDENCIA);
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        return this.integracaoFolhaPortalTransparenciaClient.loadVencimentosOuDescontos(PortalTransparenciaVencimentosDescontosParamDTOConverter.toPortalTransparenciaVencimentosDescontosParamDTO((ServidorParams)params, (Boolean)irrfPrevidenciaOutrosDescontos)).stream().map(ServidorVencimentosDescontosDTOConverter::toDTO).collect(Collectors.toList());
    }

    private Boolean getPortalParametroContabil(ServidorParams params, Long parametro) {
        PortalParametroContabil portalParametroContabil = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(params.getEntidade(), params.getExercicio(), parametro);
        if (Objects.nonNull(portalParametroContabil)) {
            return SimNao.toBoolean((String)portalParametroContabil.getValor(), (Boolean)Boolean.FALSE);
        }
        return Boolean.FALSE;
    }

    public List<LeisAtosNaturezaDTO> findNaturezas(LeisAtosParams params) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return Collections.emptyList();
        }
        return this.integracaoFolhaPortalTransparenciaClient.findAllTiposAtos().stream().map(LeisAtosNaturezaDTOConverter::toDTO).collect(Collectors.toList());
    }

    public Page<LeisAtosDTO> findAtos(LeisAtosParams params, Pageable pageable) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        EloPage atos = this.integracaoFolhaPortalTransparenciaClient.findAtos(LeisAtosParamsConverter.toPortalTransparenciaFiltroAtosDTO((LeisAtosParams)params), pageable);
        return new PageImpl(atos.getContent().stream().map(LeisAtosDTOConverter::toPortalTransparenciaFiltroAtosDTO).collect(Collectors.toList()), pageable, atos.getTotalElements());
    }

    public LeisAtosDTO findAto(LeisAtosParams params) {
        if (!params.getId().isPresent() || !this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return null;
        }
        if (params.getId().isPresent()) {
            return LeisAtosDTOConverter.toPortalTransparenciaFiltroAtosDTO((PortalTransparenciaAtoDTO)this.integracaoFolhaPortalTransparenciaClient.findAto((Long)params.getId().get()));
        }
        return null;
    }

    public List<QuadroPessoalDTO> findQuadroPessoal(CargoParams params) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return null;
        }
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        if (Objects.nonNull(params.getCompetencia())) {
            return this.integracaoFolhaPortalTransparenciaClient.findQuadroPessoalDTO(params.getEntidade(), params.getExercicio(), params.getCompetencia()).stream().map(QuadroPessoalDTOConverter::toQuadroPessoalDTO).collect(Collectors.toList());
        }
        return this.integracaoFolhaPortalTransparenciaClient.findQuadroPessoalDTO(params.getEntidade(), params.getExercicio()).stream().map(QuadroPessoalDTOConverter::toQuadroPessoalDTO).collect(Collectors.toList());
    }

    public Page<EstagiarioDTO> loadEstagiarios(ServidorParams params, Pageable pageable) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        EloPage estagiarios = this.integracaoFolhaPortalTransparenciaClient.getEstagiarios(ServidorParamsConverter.toDTO((ServidorParams)params), pageable);
        return new PageImpl(estagiarios.getContent().stream().map(EstagiarioDTOConverter::portalTransparenciaServidoresDTOToEstagiarioDTO).collect(Collectors.toList()), pageable, estagiarios.getTotalElements());
    }

    public Optional<EstagiarioDTO> dadosEstagiario(ServidorParams params) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return Optional.empty();
        }
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        return Optional.of(EstagiarioDTOConverter.portalTransparenciaDadosServidorDTOToEstagiarioDTO((PortalTransparenciaDadosServidorDTO)this.integracaoFolhaPortalTransparenciaClient.getDadosEstagiario(params.getEntidadeAise(), params.getExercicio(), params.getMatricula())));
    }

    @Generated
    public IntegracaoOxyFolhaPagamentoServiceImpl(ParametroRepositoryImpl parametroRepository, PortalParametroRepository portalParametroRepository, EntidadeAiseService entidadeAiseService, IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient) {
        this.parametroRepository = parametroRepository;
        this.portalParametroRepository = portalParametroRepository;
        this.entidadeAiseService = entidadeAiseService;
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
    }
}

