SELECT DISTINCT I.DATAVALIDADE, 
       TCM.AREAUTILIZADA, 
       TCM.ATIVIDADEPRINCIPAL, 
       I.NUMERODOCUMENTO AS NUMEROALVARA,
       I.IDCADASTROGERALIMAGEM AS IDARQUIVO,
       I.MIMETYPE AS EXTENSAO,
       I.TIPODOCUMENTO
  FROM ${db.aise.schema}.TRIBCADASTROMOBILIARIO TCM
  JOIN ${db.aise.schema}.TRIBCADASTROGERAL TCG
    ON TCM.TIPOCADASTRO = TCG.TIPOCADASTRO
   AND TCM.CADASTROGERAL = TCG.CADASTROGERAL
  JOIN ${db.aise.schema}.PESSOA P
    ON TCG.PESSOA = P.PESSOA
  LEFT JOIN ${db.aise.schema}.TRIBCADASTROGERALIMAGEM I
    ON I.TIPOCADASTRO = TCG.TIPOCADASTRO
   AND I.CADASTROGERAL = TCG.CADASTROGERAL
   AND I.PESSOA = P.PESSOA
 WHERE TCM.ENTIDADE = :entidade
   AND P.PESSOA = :pessoa
AND COALESCE(I.DATAVALIDADE, CURRENT_DATE) >= TRUNC(CURRENT_DATE)
 ORDER BY I.DATAVALIDADE
