/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PermutaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.RegistroPontoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosPensaoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorResumoNaturezaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidoresHorasExtrasDTO;
import br.com.elotech.portaltransparencia.aiseportal.service.ServidorService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.web.rest.params.PermutaParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/servidores"})
public class ServidorResource {
    private final ServidorService servidorService;
    private final ElotechProperties elotechProperties;
    private final BaseExport baseExport;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private static final Integer MAXIMO_REGISTROS_SERVIDORES = 13000;

    @Autowired
    public ServidorResource(ServidorService servidorService, ElotechProperties elotechProperties, BaseExport baseExport, EntidadeContabilidadeRepository entidadeRepository) {
        this.servidorService = servidorService;
        this.elotechProperties = elotechProperties;
        this.baseExport = baseExport;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping
    public ResponseEntity<Page<ServidorDTO>> loadServidores(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams, Pageable pageable) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.servidorService.loadServidores(servidorParams, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView loadServidoresExport(HttpServletRequest request, HttpServletResponse response, @Valid ServidorParams servidorParams, Pageable pageable) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)MAXIMO_REGISTROS_SERVIDORES, (Sort)pageable.getSort());
        Page servidoresPage = this.servidorService.loadServidores(servidorParams, (Pageable)page);
        return this.exportReport(request, response, servidorParams, servidoresPage);
    }

    @GetMapping(value={"/{matricula}"})
    public ResponseEntity<ServidorDTO> findServidor(@PathVariable Long matricula, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setMatricula(matricula);
        Optional servidor = this.servidorService.loadServidor(servidorParams);
        if (servidor.isPresent()) {
            return ResponseEntity.ok((Object)((ServidorDTO)servidor.get()));
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{vinculo}/{matricula}/{entidadeOrigem}"})
    public ResponseEntity<ServidorDTO> findServidorPorVinculo(@PathVariable(name="vinculo") String vinculo, @PathVariable(name="matricula") Long matricula, @PathVariable(name="entidadeOrigem") Long entidadeOrigem, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setMatricula(matricula);
        servidorParams.setVinculo(vinculo);
        servidorParams.setEntidadeOrigem(entidadeOrigem);
        Optional servidor = this.servidorService.loadServidor(servidorParams);
        if (servidor.isPresent()) {
            return ResponseEntity.ok((Object)((ServidorDTO)servidor.get()));
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/dados-pensao"}, params={"matricula", "entidadeOrigem"})
    public ResponseEntity<ServidorDadosPensaoDTO> findDadosPensaoServidor(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        Optional servidor = this.servidorService.loadPensaoServidor(servidorParams);
        return servidor.map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @GetMapping(value={"/vencimentos-descontos"}, params={"matricula", "anoCompetencia", "mesCompetencia", "tipoEvento", "tipoFolha", "codigoCalculo", "entidadeOrigem"})
    public ResponseEntity<List<ServidorVencimentosDescontosDTO>> loadVencimentosEDescontosServidor(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.servidorService.loadVencimentoEDescontos(servidorParams));
    }

    @GetMapping(value={"/registros-pontos"}, params={"matricula", "anoCompetencia", "mesCompetencia"})
    public ResponseEntity<List<RegistroPontoDTO>> loadRegistroPontoServidor(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        return ResponseEntity.ok((Object)this.servidorService.loadRegistroPonto(servidorParams));
    }

    @GetMapping(value={"/situacoes"})
    public ResponseEntity<List<String>> getSituacoes(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.servidorService.getSituacoes(entidade, exercicio));
    }

    @GetMapping(value={"/resumonatureza"})
    public ResponseEntity<List<ServidorResumoNaturezaDTO>> loadServidoresResumoNatureza(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.servidorService.loadServidoresResumoNatureza(servidorParams));
    }

    @GetMapping(value={"/aposentados"})
    public ResponseEntity<Page<ServidorDTO>> loadServidoresAposentados(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams, Pageable pageable) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setSituacao("Aposentado(a)");
        return ResponseEntity.ok((Object)this.servidorService.loadAposentadosPensionistas(servidorParams, pageable));
    }

    @GetMapping(value={"/aposentados/report"})
    public ModelAndView loadServidoresAposentadosExport(HttpServletRequest request, HttpServletResponse response, @Valid ServidorParams servidorParams, Pageable pageable) throws Throwable {
        servidorParams.setSituacao("Aposentado(a)");
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros());
        Page aposentadosPage = this.servidorService.loadAposentadosPensionistas(servidorParams, (Pageable)page);
        return this.exportReport(request, response, servidorParams, aposentadosPage);
    }

    @GetMapping(value={"/hora-extra"}, params={"mesCompetencia"})
    public ResponseEntity<ServidoresHorasExtrasDTO> loadServidoresHorasExtras(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setAnoCompetencia(exercicio);
        Optional horaExtra = this.servidorService.loadServidoresHorasExtras(servidorParams);
        return horaExtra.map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @GetMapping(value={"/permutas"})
    public ResponseEntity<Page<PermutaDTO>> loadPermutas(@RequestHeader(value="entidade") Long entidade, @Valid PermutaParams permutaParams, Pageable pageable) {
        return ResponseEntity.ok((Object)this.servidorService.loadPermutas(permutaParams, pageable));
    }

    private ModelAndView exportReport(HttpServletRequest request, HttpServletResponse response, ServidorParams servidorParams, Page<ServidorDTO> servidoresPage) throws Throwable {
        Entidade entidadeContabil = (Entidade)this.entidadeRepository.findOne((Object)servidorParams.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeContabil.getNome());
        reportParam.setReportTitle("Servidores");
        reportParam.setClazzDTO(ServidorDTO.class);
        String headerFields = "Nome,Matr\u00edcula,Situa\u00e7\u00e3o,Cargo,Classe,Natureza,Lota\u00e7\u00e3o";
        String fields = "nome,matricula,situacao,descricaoCargo,descricaoClasse,descricaoNatureza,descricaoLotacao";
        float[] fieldsPerc = new float[]{1.5f, 0.9f, 1.0f, 1.5f, 1.8f, 1.5f, 1.8f};
        int[] fieldTab = new int[]{100, 20, 20, 100, 100, 100, 100};
        if (this.servidorService.utilizaWebService()) {
            headerFields = "Nome,Matr\u00edcula,Situa\u00e7\u00e3o,Cargo,Lota\u00e7\u00e3o";
            fields = "nome,matricula,situacao,descricaoCargo,descricaoLotacao";
            fieldsPerc = new float[]{1.5f, 0.9f, 1.0f, 1.5f, 1.8f};
            fieldTab = new int[]{100, 20, 20, 100, 100};
        }
        reportParam.setHeaderFields(headerFields);
        reportParam.setFields(fields);
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(servidoresPage);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(servidorParams.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

