 SELECT A.ENTIDADE,           A.EXERCICIO,
        A.EXERCICIOLICITACAO, A.TIPOLICITACAO,
        A.LICITACAO,          A.PESSOA,
        P.NOME,               P.CNPJ_CPF AS CNPJCPF, 
        A.DATA               
   FROM ${db.compras.schema}.CLHOMOLOGACAO A
   LEFT JOIN ${db.compras.schema}.CLLICITACAO B
     ON A.ENTIDADE           = B.ENTIDADE 
    AND A.EXERCICIOLICITACAO = B.EXERCICIO 
    AND A.TIPOLICITACAO      = B.TIPOLICITACAO 
    AND A.LICITACAO          = B.LICITACAO 
   LEFT JOIN ${db.compras.schema}.PESSOA P
     ON A.PESSOA = P.PESSOA   
  WHERE A.ENTIDADE           = :entidade
    AND A.EXERCICIOLICITACAO = :exercicio
    AND A.TIPOLICITACAO      = :tipoLicitacao
    AND A.LICITACAO          = :licitacao
    AND EXISTS ( SELECT ANALIS.ENTIDADE 
                   FROM ${db.compras.schema}.CLANALISEVENCEDOR ANALIS
                  WHERE A.ENTIDADE           = ANALIS.ENTIDADE 
                    AND A.EXERCICIOLICITACAO = ANALIS.EXERCICIOLICITACAO 
                    AND A.TIPOLICITACAO      = ANALIS.TIPOLICITACAO 
                    AND A.LICITACAO          = ANALIS.LICITACAO 
                    AND A.PESSOA             = ANALIS.PESSOA 
                    AND ANALIS.VENCEDOR = 'S' )