/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.mapper;

import br.com.elotech.portaltransparencia.protocportal.domain.Contato;
import br.com.elotech.portaltransparencia.protocportal.domain.Pessoa;
import br.com.elotech.unico.client.dto.ContatoDTO;
import br.com.elotech.unico.client.dto.PessoaContatoDTO;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.client.dto.PessoaRg;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class PessoaToDto
implements Converter<Pessoa, PessoaDTO> {
    public PessoaDTO convert(Pessoa entity) {
        PessoaDTO dto = new PessoaDTO();
        dto.setId(entity.getId());
        dto.setNome(entity.getNome());
        dto.setCnpjCpf(entity.getCnpjCpf());
        dto.setTipoPessoa(this.tipoPessoa(entity));
        dto.setRg(this.builRg(entity));
        if (entity.getContato() != null) {
            dto.getContatos().addAll(this.buildContatoList(entity.getContato()));
        }
        dto.setProtocolo(Boolean.TRUE);
        return dto;
    }

    private String tipoPessoa(Pessoa entity) {
        if (entity.getTipoPessoa() != null) {
            return entity.getTipoPessoa().getValue();
        }
        return null;
    }

    private PessoaRg builRg(Pessoa pessoa) {
        PessoaRg rg = new PessoaRg();
        rg.setNumero(pessoa.getRg());
        return rg;
    }

    private List<PessoaContatoDTO> buildContatoList(Contato contato) {
        PessoaContatoDTO dto = new PessoaContatoDTO();
        ContatoDTO contatoDto = new ContatoDTO();
        contatoDto.setNome("contato");
        contatoDto.setTelefoneCelular(contato.getCelular());
        contatoDto.setTelefoneResidencial(contato.getTelefone());
        contatoDto.setEmail(contato.getEmail());
        dto.setContato(contatoDto);
        ArrayList<PessoaContatoDTO> list = new ArrayList<PessoaContatoDTO>();
        list.add(dto);
        return list;
    }
}

