/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.service.impl;

import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.comprasportal.domain.AdjudicacaoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AdjudicacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.AdjudicacaoArquivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.repository.AdjudicacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAdjudicacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.AdjudicacaoService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdjudicacaoServiceImpl
implements AdjudicacaoService {
    private final AdjudicacaoRepository adjudicacaoRepository;
    private final AdjudicacaoArquivoRepository adjudicacaoArquivoRepository;
    private final EloArquivoRepository eloArquivoRepository;
    private final ArquivoService arquivoService;

    @Autowired
    public AdjudicacaoServiceImpl(AdjudicacaoRepository adjudicacaoRepository, AdjudicacaoArquivoRepository adjudicacaoArquivoRepository, EloArquivoRepository eloArquivoRepository, ArquivoService arquivoService) {
        this.adjudicacaoRepository = adjudicacaoRepository;
        this.adjudicacaoArquivoRepository = adjudicacaoArquivoRepository;
        this.eloArquivoRepository = eloArquivoRepository;
        this.arquivoService = arquivoService;
    }

    public List<AdjudicacaoLicitacaoDTO> findAdjudicacoes(FindLicitacaoParams params) {
        return this.adjudicacaoRepository.findAdjudicacoes(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public AdjudicacaoLicitacaoDTO findAdjudicacao(FindAdjudicacaoParams params) {
        return this.adjudicacaoRepository.findAdjudicacao(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<AdjudicacaoArquivo> findArquivos(FindAdjudicacaoParams params) {
        if (!params.getTipoLicitacao().isPresent() && !params.getLicitacao().isPresent()) {
            return new ArrayList<AdjudicacaoArquivo>();
        }
        List adjudicacaoArquivos = this.adjudicacaoArquivoRepository.findByEntidadeAndExercicioAndExercicioLicitacaoAndTipoLicitacaoAndLicitacaoAndPessoa((Long)params.getEntidade().get(), (Long)params.getExercicio().get(), (Long)params.getExercicioLicitacao().get(), (Long)params.getTipoLicitacao().get(), (Long)params.getLicitacao().get(), (Long)params.getPessoa().get());
        adjudicacaoArquivos.stream().filter(AdjudicacaoArquivo::possuiEloArquivo).map(AdjudicacaoArquivo::getArquivoCompras).forEach(a -> a.setTamanhoArquivo(this.eloArquivoRepository.getTamanhoArquivo(a.getArquivo().getId())));
        return adjudicacaoArquivos;
    }
}

