/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CedidoDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.CedidoRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindCedidoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CedidoRepositoryImpl
implements CedidoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CedidoRepositoryImpl.class);
    private final EntidadeAiseService entidadeAiseService;
    private static final String CEDIDOS = "db/sql/aise/cedidos.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public CedidoRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
    }

    public Page<CedidoDTO> findCedidos(FindCedidoParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)CEDIDOS));
        StringBuilder filtro = new StringBuilder();
        if (!params.getCedenteFinalizado().booleanValue()) {
            filtro.append(" AND ((ML.DATATERMINO IS NULL) OR (ML.DATATERMINO > :dataAtual)) ");
            filtro.append(" AND ((AF.DATAFINAL IS NULL) OR (AF.DATAFINAL > :dataAtual)) ");
            sql.append(" WHERE (X.DATAFIM IS NULL OR EXTRACT (YEAR FROM X.DATAFIM) >= :exercicio) ");
            sql.append("   AND EXTRACT (YEAR FROM X.DATAINICIO) <= :exercicio ");
        } else {
            filtro.append(" AND (((ML.DATATERMINO IS NOT NULL) AND (ML.DATATERMINO <= :dataAtual)) ");
            filtro.append("      OR ((AF.DATAFINAL IS NOT NULL) AND (AF.DATAFINAL <= :dataAtual))) ");
        }
        params.getNome().ifPresent(item -> filtro.append(" AND ${db.aise.schema}.tiraacento(LOWER(FP.NOME)) LIKE ${db.aise.schema}.tiraacento(LOWER(:nome)) "));
        String query = sql.toString().replace("$[FILTRO]", filtro.toString());
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(SqlUtils.createSQLCount((String)query), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query, (String)"ORDER BY NOME");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query);
            LOGGER.debug(params.toString());
        }
        List cedidos = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(CedidoDTO.class));
        return new PageImpl(cedidos, pageable, total.longValue());
    }
}

