SELECT EX.MES, 
   CAST(COALESCE((SELECT COALESCE(SUM(RD.VALORARRECADADO-RD.VALORESTARRECADADO-RD.VALORDEVOLUCAO+RD.VALORESTDEVOLUCAO),0) 
           FROM ${db.contabilidade.schema}.RECEITADIARIA RD
           LEFT OUTER JOIN ${db.contabilidade.schema}.RECEITA R
             ON RD.ENTIDADE = R.ENTIDADE 
            AND RD.EXERCICIO = R.EXERCICIO 
            AND RD.RECEITA = R.RECEITA 
            AND RD.FONTERECURSO = R.FONTERECURSO 
            AND RD.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA
           WHERE EX.ENTIDADE = RD.ENTIDADE 
             AND EX.EXERCICIO = RD.EXERCICIO 
             AND EX.MES = EXTRACT(MONTH FROM RD.DATA) 
             AND R.MOVSN = 'S'),0) AS NUMERIC(15,2)) VALORARRECADADO,

CAST(((COALESCE((SELECT COALESCE(SUM(R.VALORORCADO), 0) +
                        COALESCE(SUM((SELECT COALESCE(SUM(RECM.VALORCORRECAOORCADO + RECM.VALORCORRECAO), 0)
                                        FROM ${db.contabilidade.schema}.RECEITAMENSAL RECM
                                       WHERE R.ENTIDADE = RECM.ENTIDADE
                                         AND R.EXERCICIO = RECM.EXERCICIO
                                         AND R.RECEITA = RECM.RECEITA
                                         AND R.IDTIPOOPERACAORECEITA = RECM.IDTIPOOPERACAORECEITA
                                         AND R.FONTERECURSO = RECM.FONTERECURSO)),0) AS CORRECAO
                   FROM ${db.contabilidade.schema}.RECEITA R
                  WHERE R.ENTIDADE = EX.ENTIDADE
                    AND R.EXERCICIO = EX.EXERCICIO
                    AND R.MOVSN = 'S'),0) +
       COALESCE((SELECT SUM(A.VALORATIVA)
                   FROM ${db.contabilidade.schema}.ORCINTERFERENCIA A
                   LEFT OUTER JOIN ${db.contabilidade.schema}.ORCVERSAOORCAMENTO B
                     ON B.ENTIDADE = A.ENTIDADE
                    AND B.EXERCICIO = A.EXERCICIO
                    AND B.VERSAO = A.VERSAO
                  WHERE A.ENTIDADE = EX.ENTIDADE
                    AND A.EXERCICIO = EX.EXERCICIO
                    AND B.SITUACAO = 2),0)) / 12) AS NUMERIC(15,2)) VALORPREVISTO
 FROM ${db.contabilidade.schema}.EXERCICIO_MES EX
 WHERE EX.ENTIDADE = :entidade
 AND EX.EXERCICIO  = :exercicio
 ORDER BY EX.MES