CREATE OR REPLACE VIEW ${db.aise.schema}.VW_SITUACAOFUNCIONARIO AS
SELECT F.ENTIDADE, F.MATRICULA,
CASE WHEN F.SITUACAO = 1 THEN 'ATIVO'   
       WHEN (F.SITUACAO = 2) AND (EXISTS (SELECT DISTINCT MA.ENTIDADE 
                                     FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA
                                     WHERE MA.ENTIDADE = F.ENTIDADE
                                       AND MA.MATRICULA = F.MATRICULA    
                                       AND MA.DATAINICIAL = (SELECT MAX(MA.DATAINICIAL) AS DATAINICIAL
                                                               FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA
                                                              WHERE MA.ENTIDADE = F.ENTIDADE
                                                                AND MA.MATRICULA = F.MATRICULA
                                                                AND (MA.DATAFINAL >= CURRENT_DATE OR MA.DATAFINAL IS NULL)))) THEN 'AFASTADO - ' ||   
        Coalesce((SELECT A.DESCRICAO 
                FROM ${db.aise.schema}.RHAFASTAMENTO A
                WHERE A.ENTIDADE = F.ENTIDADE
                AND A.AFASTAMENTO = (SELECT MAX(AFASTAMENTO) 
                                     FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA
                                     WHERE MA.ENTIDADE = F.ENTIDADE
                                       AND MA.MATRICULA = F.MATRICULA    
                                       AND MA.DATAINICIAL = (SELECT MAX(MA.DATAINICIAL) AS DATAINICIAL
                                                               FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA
                                                              WHERE MA.ENTIDADE = F.ENTIDADE
                                                                AND MA.MATRICULA = F.MATRICULA
                                                                AND (MA.DATAFINAL >= CURRENT_DATE OR MA.DATAFINAL IS NULL)))) ,' ') || ' ' ||   

        Coalesce((SELECT DISTINCT 'LICENÇA PRÊMIO'
                  FROM ${db.aise.schema}.RHPROGRAMACAOPREMIO A
                  WHERE A.ENTIDADE = F.ENTIDADE
                    AND A.MATRICULA = F.MATRICULA
                    AND (A.FIMPECUNIA >= CURRENT_DATE AND A.INICIOPECUNIA <= CURRENT_DATE)
                    AND (A.FIMGOZO >= CURRENT_DATE OR (A.FIMGOZO IS NULL AND A.INICIOGOZO IS NOT NULL))),' ')


      WHEN F.SITUACAO = 3 
        AND F.DATASITUACAO <= CURRENT_DATE 
        AND EXISTS (SELECT MP.ENTIDADE FROM ${db.aise.schema}.RHMOVIMENTACAOPESSOAL MP
                     WHERE MP.ENTIDADE = F.ENTIDADE
                       AND MP.MATRICULA = F.MATRICULA
                       AND MP.TIPOMOVIMENTACAO = 7) THEN 'EXONERADO'

      WHEN F.SITUACAO = 3 
      	AND F.DATASITUACAO <= CURRENT_DATE 
      	AND (EXISTS (SELECT MP.ENTIDADE FROM ${db.aise.schema}.RHMOVIMENTACAOPESSOAL MP
              		  WHERE MP.ENTIDADE = F.ENTIDADE 
              		    AND MP.MATRICULA = F.MATRICULA 
              		    AND (mp.tipomovimentacao IN (8, 9, 10, 11)))) THEN 'INATIVO'
            
      WHEN F.SITUACAO = 3 AND F.DATASITUACAO <= CURRENT_DATE THEN 'DEMITIDO'
    ELSE 'ATIVO' END AS SITUACAO, 
	EXTRACT(YEAR FROM CURRENT_DATE) ANOCOMPETENCIA
FROM ${db.aise.schema}.RHFUNCIONARIO F

UNION ALL 

SELECT DISTINCT HF.ENTIDADE, HF.MATRICULA,
CASE WHEN HF.SITUACAO = 1 THEN 'ATIVO'   
       WHEN (HF.SITUACAO = 2) AND (EXISTS (SELECT DISTINCT MA.ENTIDADE 
                                     FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA
                                     WHERE MA.ENTIDADE = HF.ENTIDADE
                                       AND MA.MATRICULA = HF.MATRICULA    
                                       AND MA.DATAINICIAL = (SELECT MAX(MA.DATAINICIAL) AS DATAINICIAL
                                                               FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA
                                                              WHERE MA.ENTIDADE = HF.ENTIDADE
                                                                AND MA.MATRICULA = HF.MATRICULA
                                                                AND (MA.DATAFINAL >= CAST(CAST(hf.anocompetencia AS varchar(4))||'-'||'12-31' AS date) OR MA.DATAFINAL IS NULL)))) THEN 'AFASTADO - ' ||   
        Coalesce((SELECT A.DESCRICAO 
                FROM ${db.aise.schema}.RHAFASTAMENTO A
                WHERE A.ENTIDADE = HF.ENTIDADE
                AND A.AFASTAMENTO = (SELECT MAX(AFASTAMENTO) 
                                     FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA
                                     WHERE MA.ENTIDADE = HF.ENTIDADE
                                       AND MA.MATRICULA = HF.MATRICULA    
                                       AND MA.DATAINICIAL = (SELECT MAX(MA.DATAINICIAL) AS DATAINICIAL
                                                               FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA
                                                              WHERE MA.ENTIDADE = HF.ENTIDADE
                                                                AND MA.MATRICULA = HF.MATRICULA
                                                                AND (MA.DATAFINAL >= CAST(CAST(hf.anocompetencia AS varchar(4))||'-'||'12-31' AS date) OR MA.DATAFINAL IS NULL)))) ,' ') || ' ' ||   

        Coalesce((SELECT DISTINCT 'LICENÇA PRÊMIO'
                  FROM ${db.aise.schema}.RHPROGRAMACAOPREMIO A
                  WHERE A.ENTIDADE = HF.ENTIDADE
                    AND A.MATRICULA = HF.MATRICULA
                    AND (A.FIMPECUNIA >= CAST(CAST(hf.anocompetencia AS varchar(4))||'-'||'12-31' AS date) AND A.INICIOPECUNIA <=CAST(CAST(hf.anocompetencia AS varchar(4))||'-'||'12-31' AS date))
                    AND (A.FIMGOZO >=CAST(CAST(hf.anocompetencia AS varchar(4))||'-'||'12-31' AS date) OR (A.FIMGOZO IS NULL AND A.INICIOGOZO IS NOT NULL))),' ')


      WHEN HF.SITUACAO = 3 
        AND EXISTS (SELECT MP.ENTIDADE FROM ${db.aise.schema}.RHMOVIMENTACAOPESSOAL MP
                     WHERE MP.ENTIDADE = HF.ENTIDADE
                       AND MP.MATRICULA = HF.MATRICULA
                       AND MP.TIPOMOVIMENTACAO = 7) THEN 'EXONERADO'

      WHEN HF.SITUACAO = 3 
      	AND (EXISTS (SELECT MP.ENTIDADE FROM ${db.aise.schema}.RHMOVIMENTACAOPESSOAL MP
              		  WHERE MP.ENTIDADE = HF.ENTIDADE 
              		    AND MP.MATRICULA = HF.MATRICULA 
              		    AND (mp.tipomovimentacao IN (8, 9, 10, 11)))) THEN 'INATIVO'
            
      WHEN HF.SITUACAO = 3 THEN 'DEMITIDO'
    ELSE 'ATIVO' END AS SITUACAO, 
	HF.ANOCOMPETENCIA ANOCOMPETENCIA
 FROM ${db.aise.schema}.RHHISTORICOFUNCIONARIO HF
WHERE HF.MESCOMPETENCIA = 12

